% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_nm.R
\name{pre_fixef_extractor_nm}
\alias{pre_fixef_extractor_nm}
\title{THETA extraction from results file}
\usage{
pre_fixef_extractor_nm(res_path)
}
\arguments{
\item{res_path}{(string) (Path/)Name of the results file of a NONMEM run, must include file extension, e.g., \dQuote{.res}}
}
\value{
Named vector with parameter estimates from the previous run
}
\description{
Function to extract THETA estimates from a results file of an already run NONMEM file.
}
\details{
Can be used, e.g., to initialize THETAs of a run with inter-individual variability with
estimated THETAs of a previous population run without inter-individual variability. Parameters, for which
final gradient is equal to 0 are fixed to 0, because a gradient of 0 indicates that corresponding neuron 
was inactivated during parameter estimation.
}
\examples{
res_path <- system.file("extdata","nm_example1_model_converted_ind.res",package="pmxNODE")
pre_fixef <- pre_fixef_extractor_nm(res_path)
}
\author{
Dominic Bräm
}
