% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distr.R
\name{d_unif_polysph}
\alias{d_unif_polysph}
\title{Density of the uniform distribution on the polysphere}
\usage{
d_unif_polysph(x, d, log = FALSE)
}
\arguments{
\item{x}{a matrix of size \code{c(nx, sum(d) + r)} with the evaluation
points.}

\item{d}{vector of size \code{r} with dimensions.}

\item{log}{compute the logarithm of the density? Defaults to \code{FALSE}.}
}
\value{
A vector of size \code{nx} with the evaluated density.
}
\description{
Computes the density of the uniform distribution on the
polysphere.
}
\examples{
# Simple check of integration on S^1 x S^2
d <- c(1, 2)
x <- r_unif_polysph(n = 1e4, d = d)
mean(1 / d_unif_polysph(x = x, d = d)) / prod(rotasym::w_p(p = d + 1))
}
