% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_process.R
\encoding{UTF-8}
\name{data_process}
\alias{data_process}
\title{Create the table of the drug treatments}
\usage{
data_process(
  Rx_deliv,
  Rx_id,
  Rx_drug_code,
  Rx_drug_deliv,
  Rx_deliv_dur,
  Cohort = NULL,
  Cohort_id = NULL,
  Hosp_stays = NULL,
  Hosp_id = NULL,
  Hosp_admis = NULL,
  Hosp_discharge = NULL,
  study_start = NULL,
  study_end = NULL,
  grace_fctr = 0.5,
  grace_cst = 0,
  max_reserve = NULL,
  cores = parallel::detectCores(logical = FALSE),
  ...
)
}
\arguments{
\item{Rx_deliv}{Name of the table listing all prescription drugs deliveries including the run-in period. See \emph{Details}.}

\item{Rx_id}{Column name of \code{Rx_deliv} containing individual unique identifier (any format).}

\item{Rx_drug_code}{Column name of \code{Rx_deliv} that contains the drug unique identifier (any format).}

\item{Rx_drug_deliv}{Column name of \code{Rx_deliv} that contains the dates of the drug delivery (Date format, see \emph{Details}).}

\item{Rx_deliv_dur}{Column name of \code{Rx_deliv} that contains the duration of the delivery (integer number).}

\item{Cohort}{Name of the table providing the unique identifiers of the study cohort. Only the ids listed in both the \code{Cohort} and the \code{Rx_deliv} tables will be returned. if \code{Cohort = NULL}, all ids of the \code{Rx_deliv} table will be returned.}

\item{Cohort_id}{Column name of \code{Cohort} containing individual’s unique identifiers (same format as \code{Rx_id}). If \code{Cohort} is not \code{NULL} and \code{Cohort_id} is \code{NULL}, \code{Cohort_id} will take the same value as \code{Rx_id}.}

\item{Hosp_stays}{Name of the table listing all hospital stays. (see \emph{Details} for possible format).}

\item{Hosp_id}{Column name of \code{Hosp_stays} containing individual’s unique identifier (same format as \code{Rx_id}). If \code{Hosp_stays} is not \code{NULL} and \code{Hosp_id} is \code{NULL}, \code{Hosp_id} will take the same value as \code{Rx_id}.}

\item{Hosp_admis}{Column name of \code{Hosp_stays} that contains the date of admission in hospital (Date format, see \emph{Details}).}

\item{Hosp_discharge}{Column name of Hosp_stays that contains the date of discharge from hospital (Date format, see \emph{Details}).}

\item{study_start, study_end}{Defines the first and last day of the study period for which the polypharmacy indicator(s) need to be calculated. All treatment periods prior to \code{study_start} and past \code{study_end} are not transcribed into the result table (Date format, see \emph{Details}).}

\item{grace_fctr, grace_cst}{Numbers \eqn{\ge} 0. Two types of grace periods can be applied. One is proportional to the treatment duration of the latest delivery (\code{grace_fctr}) and the other is a constant number of days (\code{grace_cst}).}

\item{max_reserve}{An integer number \eqn{\ge} 0 or \code{NULL}. Longest treatment duration, in days, that can be stored from successive overlapping deliveries. When \code{max_reserve = NULL} no limit is applied. When \code{max_reserve = 0} no accumulation of extra treatment duration is accounted for.}

\item{cores}{The number of cores to use when executing \code{data_process()}. See \code{\link[parallel]{detectCores}}.}

\item{...}{Additional arguments. See \emph{Details}. Should not be used.}
}
\value{
\code{data.table} with four (4) variables:
\itemize{
\item The individual unique identifier which name is defined by \code{Rx_id}.
\item The drug unique identifier which name is defined by \code{Rx_drug_code}.
\item \code{tx_start}: The date of initiation of the reconstructed continued treatment (format as date).
\item \code{tx_end}: The date of the last day of the reconstructed continued treatment (format as date).
}
}
\description{
Reads a table of successive drug delivery records (usually extracted from a pharmacy or a health insurance information system) and creates the table required for the calculation of the polypharmacy indicators by applying various user-defined arguments, incorporating hospital stays into the treatment periods and reconstruct continuous treatment periods by merging quasi continuous and/or overlapping drugs deliveries.
}
\details{
\strong{Variables}:
\itemize{
\item \code{Rx_id}, \code{Cohort_id} and \code{Hosp_id} columns must be of the same class (integer, numeric, character, ...).
\item \code{Rx_drug_deliv}, \code{Hosp_admis} and \code{Hosp_discharge} can be 1) \code{as.Date('yyyy-mm-dd')}, 2) \code{as.character('yyyy-mm-dd')} or 3) \code{as.integer()} where 0 is January 1\ifelse{html}{\out{<sup>st</sup>}}{\eqn{^{st}}}, 1970.
}

\strong{Arguments}:
\itemize{
\item \code{study_start} and \code{study_end} can be 1) \code{as.Date('yyyy-mm-dd')}, 2) \code{as.character('yyyy-mm-dd')} or 3) \code{as.integer()} where 0 is January 1\ifelse{html}{\out{<sup>st</sup>}}{\eqn{^{st}}}, 1970.
}

\strong{Hospital stays}:\cr
Drug availability is assumed to continue during the hospital stay as it is on the day prior admission. The patient is assumed to resume the consumption of the drugs delivered by community pharmacists (as recorded in \code{Rx_deliv}) the day after \code{hosp_discharge}.\cr
Grace period is always zero (0) for hospital stays.

\strong{Run-in period}:\cr
A run-in period is necessary to account for the medications that are available to the individuals on the day of \code{study_start}. It is recommended to include a run-in period of about 6 months (e.g. 7 months to account for possible delays) as some drugs are delivered for up to 6 months at once.

\strong{Grace period}:\cr
The grace period is used to determine if two successive deliveries can be considered as a continuous treatment even if there is a gap of several days for which no treatment is apparently available. Two successive deliveries of an identical drug are considered part of a single continuous treatment if the next delivery doesn’t occur more than \code{grace_cst} + (\code{grace_fctr} × \code{Rx_deliv_dur}) days after the end of the latest drug delivery. The availability of extra drugs accumulated over the successive deliveries is accounted for prior to evaluating the duration of the gap between deliveries.

\strong{Performance}\cr
For better performance, date columns are converted to integer numbers.

\strong{...}\cr
\code{verif_cols=FALSE} : For better performance, you can avoid columns class checking with \code{verif_cols=FALSE}. \strong{Not recommended}.
}
\examples{
\donttest{
### Standard evaluation
data_process(
  Rx_deliv = sample_Rx_unprocessed, Rx_id = "id", Rx_drug_code = "code",
  Rx_drug_deliv = "start", Rx_deliv_dur = "duration",
  cores = 1L
)

### Hospitalisation stays
rx1 <- data.frame(
  id = c(1L, 3:8),
  code = LETTERS[c(1, 3:8)],
  date = as.Date(c("2001-01-15", "2003-03-15", "2004-04-15", "2005-05-15",
                   "2006-06-15", "2007-07-15", "2008-08-15")),
  duration = 10L
)
hosp1 <- data.frame(
  ID = 3:8,
  ADM = as.Date(c("2003-03-10", "2004-04-25", "2005-05-12",
                  "2006-06-20", "2007-07-26", "2008-08-01")),
  DEP = as.Date(c("2003-03-14", "2004-04-30", "2005-05-17",
                  "2006-06-30", "2007-07-30", "2008-08-13"))
)
data_process(
  Rx_deliv = rx1, Rx_id = "id", Rx_drug_code = "code",
  Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
  Hosp_stays = hosp1, Hosp_id = "ID", Hosp_admis = "ADM", Hosp_discharge = "DEP",
  study_start = "2001-01-01", study_end = "2008-12-31",
  cores = 1L
)
# Many drug codes
rx2 <- data.frame(
  id = 1L,
  code = c(111L, 222L, 222L, 333L, 444L),
  date = as.Date(c("2001-01-15", "2002-02-15", "2002-03-01", "2004-04-07", "2004-05-05")),
  duration = as.integer(c(10, 10, 10, 30, 10))
)
hosp2 <- data.frame(
  id = 1L,
  adm = as.Date(c("2000-01-01", "2000-01-15", "2001-01-01", "2002-02-23", "2004-04-15")),
  dep = as.Date(c("2000-01-31", "2000-01-31", "2001-01-10", "2002-02-28", "2004-05-15"))
)
data_process(
  Rx_deliv = rx2, Rx_id = "id", Rx_drug_code = "code",
  Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
  Hosp_stays = hosp2, Hosp_id = "id", Hosp_admis = "adm", Hosp_discharge = "dep",
  study_start = "2001-01-01", study_end = "2008-12-31",
  cores = 1L
)

### Study dates - start and end
rx3 <- data.frame(id = 1:3,
                  code = "A",
                  date = as.Date(c("2020-01-01", "2020-06-06", "2020-12-22")),
                  duration = 10L)
# NULLs
data_process(Rx_deliv = rx3, Rx_id = "id", Rx_drug_code = "code",
             Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
             study_start = NULL, study_end = NULL,
             cores = 1)
# Not NULLs
data_process(Rx_deliv = rx3, Rx_id = "id", Rx_drug_code = "code",
             Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
             study_start = "2020-06-10", study_end = NULL,
             cores = 1)
data_process(Rx_deliv = rx3, Rx_id = "id", Rx_drug_code = "code",
             Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
             study_start = NULL, study_end = "2020-06-10",
             cores = 1)
data_process(Rx_deliv = rx3, Rx_id = "id", Rx_drug_code = "code",
             Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
             study_start = "2020-01-05", study_end = "2020-12-25",
             cores = 1)

### Grace factor
rx4 <- data.frame(id = c(rep(1, 3), rep(2, 3)),
                  code = "A",
                  date = as.Date(c("2000-01-01", "2000-01-17", "2000-01-31",
                                   "2000-06-01", "2000-06-23", "2000-07-16")),
                  duration = as.integer(c(10, 10, 10, 15, 15, 15)))
# 50\% of duration
data_process(Rx_deliv = rx4, Rx_id = "id", Rx_drug_code = "code",
             Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
             grace_fctr = 0.5,
             cores = 1)
# 0\% of duration
data_process(Rx_deliv = rx4, Rx_id = "id", Rx_drug_code = "code",
             Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
             grace_fctr = 0,
             cores = 1)

### Grace constant
rx5 <- data.frame(id = 1,
                  code = "A",
                  date = as.Date(c("2000-01-01", "2000-01-14", "2000-01-25")),
                  duration = as.integer(c(10, 10, 6)))
# 2 days
data_process(Rx_deliv = rx5, Rx_id = "id", Rx_drug_code = "code",
             Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
             grace_fctr = 0, grace_cst = 2,
             cores = 1)
# 3 days
data_process(Rx_deliv = rx5, Rx_id = "id", Rx_drug_code = "code",
             Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
             grace_fctr = 0, grace_cst = 3,
             cores = 1)

### Max reserve
rx6 <- data.frame(id = as.integer(c(1, 1, 3, 3, 3, 5, 5)),
                  code = "A",
                  date = as.Date(c("2000-01-01", "2000-01-31",
                                   "2000-03-03", "2000-03-15", "2000-03-30",
                                   "2000-05-05", "2000-05-05")),
                  duration = as.integer(c(30, 30,
                                          30, 30, 30,
                                          90, 90)))
# 0 days
data_process(Rx_deliv = rx6, Rx_id = "id", Rx_drug_code = "code",
             Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
             study_start = NULL, study_end = "2000-12-31",
             grace_fctr = 0, grace_cst = 0,
             max_reserve = 0,
             cores = 1)
# 60 days
data_process(Rx_deliv = rx6, Rx_id = "id", Rx_drug_code = "code",
             Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
             study_start = NULL, study_end = "2000-12-31",
             grace_fctr = 0, grace_cst = 0,
             max_reserve = 60,
             cores = 1)
# Inf days
data_process(Rx_deliv = rx6, Rx_id = "id", Rx_drug_code = "code",
             Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
             study_start = NULL, study_end = "2000-12-31",
             grace_fctr = 0, grace_cst = 0,
             max_reserve = NULL,
             cores = 1)

### Combine Hospital stays and Grace factor
rx7 <- data.frame(id = c(1L, 1L, 1L, 2L),
                  code = "A",
                  date = c("2000-01-01", "2000-02-20", "2000-04-11", "2002-02-02"),
                  duration = as.integer(c(30, 30, 30, 15)))
hosp7 <- data.frame(id = 1L,
                    adm = c("2000-01-11", "2000-02-21"),
                    dep = c("2000-01-15", "2000-02-25"))
data_process(Rx_deliv = rx7, Rx_id = "id", Rx_drug_code = "code",
             Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
             Hosp_stays = hosp7, Hosp_id = "id",
             Hosp_admis = "adm", Hosp_discharge = "dep",
             study_start = "2000-01-01", study_end = "2002-12-31",
             grace_fctr = 0.5, grace_cst = 0, max_reserve = NULL,
             cores = 1)
}
}
