% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsPreorder.R
\name{IsPreorder}
\alias{IsPreorder}
\title{Checking for pre-ordering (or quasi-ordering).}
\usage{
IsPreorder(set, rel)
}
\arguments{
\item{set}{A list of character strings (the names of the elements of the set, on which the binary relation is defined).}

\item{rel}{A two-columns character matrix, each row comprising an element (pair) of the binary relation.}
}
\value{
A boolean value.
}
\description{
Checks whether the input relation is a pre-order (aka, a quasi-order), i.e. if it is reflexive and transitive.
}
\examples{
set<-c("a", "b", "c", "d")

rel <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "a",
  "d", "a",
  "c", "a",
  "d", "b",
  "a", "a",
  "b", "b",
  "c", "c",
  "d", "d"
), ncol = 2, byrow = TRUE)

chk<-IsPreorder(set, rel)

}
