% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LD.sign.test.R
\name{LD.sign.test}
\alias{LD.sign.test}
\title{Perform the sign test on paired LD values for phased and unphased haplotypes}
\usage{
LD.sign.test(
  dataName,
  verbose = TRUE,
  returnFrame = TRUE,
  resultDir = tempdir()
)
}
\arguments{
\item{dataName}{The "base" name of the _LD_result.csv files generated by LDWrap() without the "_Phased_LD_results.csv" or "_Unphased_LD_results.csv" suffixes. See Examples, below. If the corresponding "<dataName>_Phased_LD_results.csv" or "<dataName>_Unphased_LD_results.csv" files are not found, the funciton will halt with a notification.}

\item{verbose}{A boolean identifying if messages about function progress and results should be displayed in the console (verbose=TRUE) or not (verbose=FALSE). The default is verbose=TRUE.}

\item{returnFrame}{A boolean identifying if a data frame of results should be returned (returnFrame=TRUE). If 'returnFrame=FALSE', a CSV file of results named <dataName>_LD-sign-test_results.csv is written in the directory specified by the 'resultDir' parameter. The default is returnFrame=TRUE.}

\item{resultDir}{The directory into which the CSV file of results should be written when 'returnFrame=FALSE'. The default is the directory specified by tempdir().}
}
\value{
A data frame of five columns ({D'}, {Wn}, {WLoc1/Loc2}, {WLoc2/Loc1} and N_Haplotypes) and four rows (#unphased > phased, #unphased = phased, #locus pairs and p-values).
}
\description{
Applies binom.test() to pairs of {D'}, {Wn}, {WLoc1/Loc2}, {WLoc2/Loc1} and number of haplotypes values in the *_LD_results.csv files generated by LDWrap().
}
\details{
This function returns p-values for the sign test comparing the phased and unphased values of each LD measure, as well as the number of haplotypes, for each locus pair in a dataset tested using LDWrap(). It also returns the number of locus pairs for which the value in quesiton is higher in unphased haplotypes than phased haplotypes, the number of locus pairs in which the values are the same, and the total number of locus pairs asssessed. This function writes a results file to the working directory for each dataset, and will optionally display those results in the console.
}
\note{
When verbose=TRUE, LD.sign.test() writes a table of results to the console with the column headers "Measure", "#U > P", "#U = P" and "p-value". Column "#U > P" identifies the number locus pairs for which that measure for unphased haplotypes (U) was greater than that measure for phased haplotypes (P). Similarly, column "#U = P" identiifes the number of locus pairs for each meausure where the value of that measure was the same in phased and unphased haplotypes.

Only the significance of the sign test is reported; when a significant trend is indicated, the directionality of the trend is not reported.
}
\examples{
# Using LDWrap() to analyze the first 10 rows of the drb1.dqb1.demo dataset.
# LDWrap() results are saved in the temporary directory as 
# "hla-family-data_Phased_LD_results.csv" and 
# "hla-family-data_Unphased_LD_results.csv", respectively. 
LDWrap(drb1.dqb1.demo[1:10,])
LDWrap(drb1.dqb1.demo[1:10,],phased=FALSE)
exampleData <- paste(tempdir(),"hla-family-data",sep=.Platform$file.sep)
LD.res <- LD.sign.test(exampleData)
# Return only a data frame of results.
LD.res <- LD.sign.test(exampleData,verbose=FALSE)
}
\references{
Osoegawa et al. Hum Immunol. 2019;80(9):633 (https://doi.org/10.1016/j.humimm.2019.01.010)
}
\keyword{disequilibrium}
\keyword{linkage}
\keyword{sign}
\keyword{test}
