% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_specs}
\alias{check_specs}
\title{Build a checklist for power joins}
\usage{
check_specs(
  implicit_keys = c("inform", "ignore", "warn", "abort"),
  column_conflict = c("ignore", "inform", "warn", "abort"),
  duplicate_keys_left = c("ignore", "inform", "warn", "abort"),
  duplicate_keys_right = c("ignore", "inform", "warn", "abort"),
  unmatched_keys_left = c("ignore", "inform", "warn", "abort"),
  unmatched_keys_right = c("ignore", "inform", "warn", "abort"),
  missing_key_combination_left = c("ignore", "inform", "warn", "abort"),
  missing_key_combination_right = c("ignore", "inform", "warn", "abort"),
  inconsistent_factor_levels = c("ignore", "inform", "warn", "abort"),
  inconsistent_type = c("ignore", "inform", "warn", "abort"),
  grouped_input = c("ignore", "inform", "warn", "abort"),
  na_keys = c("ignore", "inform", "warn", "abort")
)
}
\arguments{
\item{implicit_keys}{What to do if keys are not given explicitly through the
\code{by} argument}

\item{column_conflict}{What to do if the join creates a column conflict which
is not handled by the \code{conflict} argument}

\item{duplicate_keys_left}{What to do if we find duplicate sets of keys in the
left table}

\item{duplicate_keys_right}{What to do if we find duplicate sets of keys in the
right table}

\item{unmatched_keys_left}{What to do if we find unmatched sets of keys in the
left table}

\item{unmatched_keys_right}{What to do if we find unmatched sets of keys in the
right table}

\item{missing_key_combination_left}{What to do if the left table doesn't contain
all key combinations}

\item{missing_key_combination_right}{What to do if the right table doesn't contain
all key combinations}

\item{inconsistent_factor_levels}{What to do if the key columns from both sides
have inconsistent factor levels}

\item{inconsistent_type}{What to do if we joined keys have a different type}

\item{grouped_input}{What to do if one or both of the tables are grouped}

\item{na_keys}{What to do if keys contain missing values}
}
\value{
A character vector of class \code{"powerjoin_check"}
}
\description{
Build a checklist for power joins
}
\examples{
check_specs(
  implicit_keys = "ignore",
  grouped_input = "inform",
  column_conflict = "abort",
  na_keys ="warn")
}
