% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{plot_sensitivity}
\alias{plot_sensitivity}
\title{Plot Sensitivity Analysis}
\usage{
plot_sensitivity(comparison_results, parameter = "mu", dimension = 1)
}
\arguments{
\item{comparison_results}{Output from compare_discounting()}

\item{parameter}{Name of parameter to plot (default: "mu")}

\item{dimension}{For multivariate case, which dimension to plot (default: 1)}
}
\value{
A ggplot2 object (if ggplot2 is available) or base R plot
}
\description{
Creates a plot showing how posterior estimates vary with the discounting parameter.
}
\examples{
\donttest{
set.seed(123)
historical <- rnorm(50, mean = 10, sd = 2)
current <- rnorm(30, mean = 10.5, sd = 2)

comparison <- compare_discounting(historical, current)
plot_sensitivity(comparison)
}

}
