% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voipred.R
\name{evpi_val}
\alias{evpi_val}
\title{EVPI (Expected Value of Perfect Information) for validation
Takes a vector of mean and a 2X2 covariance matrix}
\usage{
evpi_val(
  Y,
  pi,
  method = c("bootstrap", "bayesian_bootstrap", "asymptotic"),
  n_sim = 1000,
  zs = (0:99)/100,
  weights = NULL
)
}
\arguments{
\item{Y}{Binary response variable}

\item{pi}{Mean of the second distribution}

\item{method}{EVPI calculation method}

\item{n_sim}{Number of Monte Carlo simulations (for bootstrap-based methods)}

\item{zs}{vector of risk thresholds at which EVPI is to be calculated}

\item{weights}{(optional) observation weights}
}
\value{
Returns a data frame containing thresholds, EVPIs, and some auxilary output.
}
\description{
EVPI (Expected Value of Perfect Information) for validation
Takes a vector of mean and a 2X2 covariance matrix
}
