% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{load_footscan}
\alias{load_footscan}
\title{Load footscan data}
\usage{
load_footscan(pressure_filepath)
}
\arguments{
\item{pressure_filepath}{String. Filepath pointing to emed pressure file}
}
\value{
A list with information about the pressure data.
\itemize{
  \item pressure_array. 3D array covering each timepoint of the measurement.
           z dimension represents time
  \item pressure_system. String defining pressure system
  \item sens_size. Numeric vector with the dimensions of the sensors
  \item time. Numeric value for time between measurements
  \item masks. List
  \item events. List
  \item sensor_polygons. Data frame with corners of sensors
  \item max_matrix. Matrix
 }
}
\description{
Imports and formats files collected on footscan systems
(formerly RSScan)
}
\examples{
footscan_data <- system.file("extdata", "footscan_test.xls", package = "pressuRe")
pressure_data <- load_footscan(footscan_data)
}
