% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_2024_conference_ptp.R
\name{calculate_esc_2024_fig_4_ptp}
\alias{calculate_esc_2024_fig_4_ptp}
\title{Calculate ESC 2024 PTP for obstructive CAD}
\usage{
calculate_esc_2024_fig_4_ptp(
  age,
  sex,
  chest_pain_type,
  have_dyspnoea,
  have_family_history,
  have_smoking_history,
  have_dyslipidemia,
  have_hypertension,
  have_diabetes,
  allow_na_symptom_score = TRUE,
  max_na_num_of_rf = 0,
  output = c("grouping", "numeric", "percentage"),
  label_sex_male = c("male"),
  label_sex_female = c("female"),
  label_sex_unknown = c(NA, NaN),
  label_have_dyspnoea_no = c("no"),
  label_have_dyspnoea_yes = c("yes"),
  label_have_dyspnoea_unknown = c(NA, NaN),
  label_cpt_no_chest_pain = c("no chest pain"),
  label_cpt_nonanginal = c("nonanginal"),
  label_cpt_atypical = c("atypical"),
  label_cpt_typical = c("typical"),
  label_cpt_unknown = c(NA, NaN),
  label_have_family_history_no = c("no"),
  label_have_family_history_yes = c("yes"),
  label_have_family_history_unknown = c(NA, NaN),
  label_have_smoking_history_no = c("no"),
  label_have_smoking_history_yes = c("yes"),
  label_have_smoking_history_unknown = c(NA, NaN),
  label_have_dyslipidemia_no = c("no"),
  label_have_dyslipidemia_yes = c("yes"),
  label_have_dyslipidemia_unknown = c(NA, NaN),
  label_have_hypertension_no = c("no"),
  label_have_hypertension_yes = c("yes"),
  label_have_hypertension_unknown = c(NA, NaN),
  label_have_diabetes_no = c("no"),
  label_have_diabetes_yes = c("yes"),
  label_have_diabetes_unknown = c(NA, NaN)
)
}
\arguments{
\item{age}{Input integer value to indicate the age of the patient in years.}

\item{sex}{The value of variable in the parameters \code{label_sex_male},
\code{label_sex_female} and \code{label_sex_unknown}.}

\item{chest_pain_type}{The value of variable in the parameters \code{label_cpt_no_chest_pain},
\code{label_cpt_nonanginal}, \code{label_cpt_atypical}, \code{label_cpt_typical} and
\code{label_cpt_unknown}.}

\item{have_dyspnoea}{The value of variable in the parameters \code{label_have_dyspnoea_no},
\code{label_have_dyspnoea_yes} and \code{label_have_dyspnoea_unknown}.}

\item{have_family_history}{The value of variable in the parameters
\code{label_have_family_history_no}, \code{label_have_family_history_yes}
and \code{label_have_family_history_unknown}.}

\item{have_smoking_history}{The value of variable in the parameters
\code{label_have_smoking_history_no}, \code{label_have_smoking_history_yes}
and \code{label_have_smoking_history_unknown}.}

\item{have_dyslipidemia}{The value of variable in the parameters
\code{label_have_dyslipidemia_no}, \code{label_have_dyslipidemia_yes}
and \code{label_have_dyslipidemia_unknown}.}

\item{have_hypertension}{The value of variable in the parameters
\code{label_have_hypertension_no}, \code{label_have_hypertension_yes}
and \code{label_have_hypertension_unknown}.}

\item{have_diabetes}{The value of variable in the parameters
\code{label_have_diabetes_no}, \code{label_have_diabetes_yes}
and \code{label_have_diabetes_unknown}.}

\item{allow_na_symptom_score}{A logical evaluating to \code{TRUE} or \code{FALSE} indicating whether we can
allow \code{chest_pain_type} or \code{have_dyspnoea} to be \code{NA} when calculating the score}

\item{max_na_num_of_rf}{Input integer 0 to 5 to indicate the maximum number of
missing risk factors to tolerate before outputting an \code{NA}.
Default: 0}

\item{output}{Input text to indicate the how pre-test
probability results be expressed
Default: c("grouping", "numeric", "percentage")
\itemize{
  \item grouping means the PTP will be expressed as Low, Intermediate and High.
  \itemize{
     \item very low if PTP is less than or equal to 5\%.
     \item low if PTP is in between 6\% to 15\%.
     \item moderate if PTP is more than 15\%.
  }
  \item numeric means the PTP will be expressed as an integer probability (0-100).
  \item percentage means the PTP will be expressed as percentage text (0-100\%).
}}

\item{label_sex_male}{Label(s) for definition(s) of male sex.
Default: \code{c("male")}}

\item{label_sex_female}{Label(s) for definition(s) of female sex.
Default: \code{c("female")}}

\item{label_sex_unknown}{Label(s) for definition(s) of missing sex.
Default: \code{c(NA, NaN)}}

\item{label_have_dyspnoea_no}{Label(s) for patient having no dyspnoea symptoms.
Default: \code{c("no")}}

\item{label_have_dyspnoea_yes}{Label(s) for patient having dyspnoea symptoms.
Default: \code{c("yes")}}

\item{label_have_dyspnoea_unknown}{Label(s) for patient having unknown dyspnoea symptoms.
Default: \code{c(NA, NaN)}}

\item{label_cpt_no_chest_pain}{Label(s) for patient having no chest pain.
Default: \code{c("no chest pain")}}

\item{label_cpt_nonanginal}{Label(s) for patient having nonanginal or non-specific chest pain.
Default: \code{c("nonanginal")}}

\item{label_cpt_atypical}{Label(s) for patient having atypical chest pain.
Default: \code{c("atypical")}}

\item{label_cpt_typical}{Label(s) for patient having typical chest pain.
Default: \code{c("typical")}}

\item{label_cpt_unknown}{Label(s) for patient having unknown chest pain type symptoms.
Default: \code{c(NA, NaN)}}

\item{label_have_family_history_no}{Label(s) for patient with no family history of CAD.
Default: \code{c("no")}}

\item{label_have_family_history_yes}{Label(s) for patient having family history of CAD.
Default: \code{c("yes")}}

\item{label_have_family_history_unknown}{Label(s) for patient
having unknown family history of CAD.
Default: \code{c(NA, NaN)}}

\item{label_have_smoking_history_no}{Label(s) for patient with
no smoking history (current or past).
Default: \code{c("no")}}

\item{label_have_smoking_history_yes}{Label(s) for patient having
smoking history (current or past).
Default: \code{c("yes")}}

\item{label_have_smoking_history_unknown}{Label(s) for patient
having unknown smoking history (current or past).
Default: \code{c(NA, NaN)}}

\item{label_have_dyslipidemia_no}{Label(s) for patient with no dyslipidemia.
Default: \code{c("no")}}

\item{label_have_dyslipidemia_yes}{Label(s) for patient having dyslipidemia.
Default: \code{c("yes")}}

\item{label_have_dyslipidemia_unknown}{Label(s) for patient
having unknown dyslipidemia.
Default: \code{c(NA, NaN)}}

\item{label_have_hypertension_no}{Label(s) for patient with no hypertension.
Default: \code{c("no")}}

\item{label_have_hypertension_yes}{Label(s) for patient having hypertension.
Default: \code{c("yes")}}

\item{label_have_hypertension_unknown}{Label(s) for patient
having unknown hypertension.
Default: \code{c(NA, NaN)}}

\item{label_have_diabetes_no}{Label(s) for patient with no diabetes.
Default: \code{c("no")}}

\item{label_have_diabetes_yes}{Label(s) for patient having diabetes.
Default: \code{c("yes")}}

\item{label_have_diabetes_unknown}{Label(s) for patient
having unknown diabetes.
Default: \code{c(NA, NaN)}}
}
\value{
An integer, percentage or category representing the patient's PTP for obstructive CAD
based on the ESC 2024 guidelines.
See parameter option \code{output} for more information.
}
\description{
This function returns a patient's
pre-test Probability (PTP) of obstructive
coronary artery disease (CAD) based on the
European Society of Cardiology (ESC) 2024 guidelines.
}
\examples{
# 30 female with symptom score of 0 and 0 risk factors
calculate_esc_2024_fig_4_ptp(
  age = 30,
  sex = "female",
  chest_pain_type = "no chest pain",
  have_dyspnoea = "no",
  have_family_history = "no",
  have_smoking_history = "no",
  have_dyslipidemia = "no",
  have_hypertension = "no",
  have_diabetes = "no",
  allow_na_symptom_score = TRUE,
  max_na_num_of_rf = 0,
  output = "percentage"
)

}
