% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{tosscoin}
\alias{tosscoin}
\title{Tossing a Coin}
\usage{
tosscoin(times, makespace = FALSE)
}
\arguments{
\item{times}{number of tosses.}

\item{makespace}{logical. Include a column of equally likely probabilities if \code{TRUE}.}
}
\value{
A data frame, with an equally likely \code{probs} column if \code{makespace} is \code{TRUE}.
}
\description{
Sets up a sample space for the experiment of tossing a coin repeatedly with the outcomes "H" or "T".
}
\details{
The function uses \code{expand.grid()} to generate all possible sequences of flips resulting from the experiment of tossing a coin. Columns of the dataframe are denoted \code{toss1}, \code{toss2}, up to \code{tosstimes}.
}
\examples{
tosscoin(2)
tosscoin(3, makespace = TRUE)

}
\seealso{
\code{\link[probs]{rolldie}}
}
\author{
G. Jay Kerns \email{gkerns@ysu.edu}.
}
\keyword{misc}
