% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bound_functions.R
\name{bound_profiles}
\alias{bound_profiles}
\title{Bound for profile extrema quantiles}
\usage{
bound_profiles(objectUQ, mean_var_delta = NULL, beta = 0.0124,
  alpha = 0.025, allPsi = NULL, options_approx = NULL,
  options_full_sims = NULL)
}
\arguments{
\item{objectUQ}{an object returned by \link{coordProf_UQ} or the object saved in \code{obj$res_UQ}, if \code{obj} is the object returned by \link{coordinateProfiles}}

\item{mean_var_delta}{the profile extrema functions at \code{options_approx$design} for the mean and variance function of the difference process \eqn{Z^\Delta = Z_x - \widetilde{Z}_x}. Object returned by \link{prof_mean_var_Delta}.}

\item{beta}{the level of confidence for the approximate simulations}

\item{alpha}{the level of confidence for the bound}

\item{allPsi}{optional list of matrices (dim \eqn{pxd}) for which to compute the profile extrema. If NULL coordinate profiles are computed.}

\item{options_approx}{an optional list of options for \link{approxMaxMin} (or \link{approxProfileExtrema} if \code{allPsi} not NULL).}

\item{options_full_sims}{an optional list of options for \link{getAllMaxMin} (or \link{getProfileExtrema} if \code{allPsi} not NULL). If NULL the full computations are not excuted. NOTE: this computations might be very expensive!}
}
\value{
a list containing \itemize{
\item{\code{bound: }}{a list containing the upper/lower bound for profile sup and inf}
\item{\code{approx: }}{a list containing the upper/lower approximate quantiles for profile sup and inf}
}
}
\description{
The function bound_profiles computes the upper and lower bounds for the profile extrema quantiles of a Gaussian process model.
}
\author{
Dario Azzimonti
}
