% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_labels.R
\name{save_labels}
\alias{save_labels}
\title{Save attribute and level labels to a CSV file}
\usage{
save_labels(.data, .filename)
}
\arguments{
\item{.data}{A \code{\link{projoint_data}} object.}

\item{.filename}{A character string giving the name of a CSV file to be written.}
}
\value{
No return value, called for side effects (writes a CSV file).
}
\description{
Saves the attributes and levels (and their order) from a \code{\link{projoint_data}}
object, as generated by \code{\link{reshape_projoint}}, to a CSV file. This
enables manual reordering and later re-import via \code{\link{read_labels}}.
}
\examples{
\donttest{
library(projoint)
data(exampleData1)
reshaped <- reshape_projoint(
  exampleData1,
  .outcomes = c(paste0("choice", 1:8), "choice1_repeated_flipped")
)
tmpfile <- tempfile(fileext = ".csv")
save_labels(reshaped, tmpfile)
readLines(tmpfile, n = 5)  # show first few lines
}

}
\seealso{
\code{\link{read_labels}}, \code{\link{reshape_projoint}}
}
