% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite.R
\name{sumComposite}
\alias{sumComposite}
\title{Score Data Using a simple sum}
\usage{
sumComposite(
  object,
  transform = c("square", "abs", "none"),
  type = c("sum", "mean"),
  systems
)
}
\arguments{
\item{object}{An object of class \code{CompositeReady}}

\item{transform}{A character string indicating the type of transformation to use.
One of \dQuote{square}, \dQuote{abs}, or \dQuote{none}, which either sums the raw data,
sums the squared data and then takes the square root, or sums the absolute values of the
data.}

\item{type}{A character string indicating the type of aggregation to use.
One of \dQuote{sum} or \dQuote{mean}.}

\item{systems}{An optional list where each element is a character vector of the
variable names within a particular system.  If given, scores are first averaged
within a system, before being aggregated across systems.}
}
\value{
An S4 object of class \code{SumScores}.
}
\description{
Create a composite using summation
}
\examples{
# this example creates distances for the built in mtcars data
# see ?mtcars for more details
# The distances are calculated from the "best" in the dataset
# First we create an appropriate CompositeData class object
# higher mpg & hp are better and lower wt & qsec are better
d <- CompositeData(mtcars[, c("mpg", "hp", "wt", "qsec")],
  thresholds = list(one = with(mtcars, c(
    mpg = max(mpg),
    hp = max(hp),
    wt = min(wt),
    qsec = min(qsec)))
  ),
  higherisbetter = c(TRUE, TRUE, FALSE, FALSE))

# create the distance scores
# and the composite
# covariance matrix will be calculated from the data
# and data will be standardized to unit variance by default
dres <- prepareComposite(d)

# see a density plot of the distance scores
dres@distanceDensity
# regular summary of distance scores
summary(dres@distances)

# examine covariance matrix
round(dres@covmat,2)

# now we can create the composite based on summing the (standardized)
# distances from our defined thresholds
# by default, distances are squared, then summed, and then square rooted
# to be back on the original scale
scomp <- sumComposite(dres, "square", "sum")

# view a histogram and summary of the composite scores
scomp@scoreHistogram
summary(scomp@scores)

# calculate average (mean) instead of sum
scomp2 <- sumComposite(dres, "square", "mean")

# view a histogram and summary of the composite scores
scomp2@scoreHistogram
summary(scomp2@scores)

# scores are still the same (just different scaling)
plot(scomp@scores, scomp2@scores)

# first average scores within a system, then sum
# within a system, scores are always averaged, never summed
scomp3 <- sumComposite(dres, "square", "sum",
  systems = list(
    environment = c("mpg"),
    performance = c("hp", "qsec", "wt")))

# view a histogram and summary of the composite scores
scomp3@scoreHistogram
summary(scomp3@scores)

# compare all three scores
# because of the different number of indicators within each system
# there is a re-weighting for S3
plot(data.frame(S1 = scomp@scores, S2 = scomp2@scores, S3 = scomp3@scores))

# cleanup
rm(d, dres, scomp, scomp2, scomp3)
}
\seealso{
Other composite: 
\code{\link{factorComposite}()},
\code{\link{mahalanobisComposite}()}
}
\concept{composite}
