% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_confintv.R
\name{psrwe_ci}
\alias{psrwe_ci}
\title{Confidence/Credible Interval for PS-Integrated Estimation}
\usage{
psrwe_ci(
  dta_psrst,
  method_ci = c("wald", "wilson"),
  conf_int = 0.95,
  conf_type = c("log_log", "plain"),
  ...
)
}
\arguments{
\item{dta_psrst}{A returned object with class \code{PSRWE_EST}}

\item{method_ci}{A method name for confidence interval (default wald)}

\item{conf_int}{A two-sided level of confidence/credible limits
(default 0.95)}

\item{conf_type}{A type name of transformation for the confidence interval
of PSKM approach}

\item{...}{Other options}
}
\value{
A list with class name \code{PSRWE_EST}.
}
\description{
Estimate the confidence/credible interval for the PS-integrated approach.
}
\details{
\code{method_ci = "wilson"} is for binary outcomes only.
         \code{conf_type = "log_log"} is for \code{ps_km} only.
}
\examples{
data(ex_dta)
dta_ps <- psrwe_est(ex_dta,
       v_covs = paste("V", 1:7, sep = ""),
       v_grp = "Group",
       cur_grp_level = "current")
ps_borrow <- psrwe_borrow(total_borrow = 30, dta_ps)
ps_rst <- psrwe_compl(ps_borrow, v_outcome = "Y_Con")
rst <- psrwe_ci(ps_rst)
rst

}
