% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptvalue.R
\name{times}
\alias{times}
\alias{div}
\title{Create times or div vector of class \strong{ptvalue}}
\usage{
times(x = double())

div(x = double())
}
\arguments{
\item{x}{A numeric vector. Values must be greater or equal than 1.}
}
\value{
A numeric vector of class \strong{ptvalue} that represent precision teaching measures.
}
\description{
\code{times()} and \code{div()} are convenient and stricter functions
for creating growing or decaying precision teaching values with numeric values
greater or equal than 1 (or otherwise raise an error).
}
\details{
Note that providing a vector of class \strong{ptvalue} to \code{times()} or \code{div()}
will raise an error as these functions are stricter.
}
\examples{
x <- c(1, 2, 4)
times(x)
div(x)

# `div()` can be useful for specifying div values without
#   the need to convert them first into values under zero
ptvalue(c(0.25, 0.5, 1, 2, 4))
ptvalue(c(div(4), div(2), 1, 2, 4))
}
