% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_pwl_fit.R
\name{adaptive_pwl_fit}
\alias{adaptive_pwl_fit}
\title{Adaptive Piecewise Linear Approximation of a Continuous Function}
\usage{
adaptive_pwl_fit(
  f,
  domain,
  tol = 0.001,
  max_iter = 50,
  initial_points = 5,
  smallconst = 1e-04
)
}
\arguments{
\item{f}{A continuous function \( f(x) \) to approximate.}

\item{domain}{Numeric vector of length 2 specifying the interval \eqn{[a, b]}.}

\item{tol}{Numeric tolerance for maximum allowed approximation error (default 1e-3).}

\item{max_iter}{Maximum number of refinement iterations (default 20).}

\item{initial_points}{Initial number of discretization points (default 5).}

\item{smallconst}{Numeric small constant used in building PWL envelope (default 1e-4).}
}
\value{
A list with components:
\describe{
\item{PWL}{A matrix of piecewise linear segments: slope, intercept, lower bound, upper bound.}
\item{data}{The final discretization points (x, y) used in fitting.}
\item{max_error}{Maximum absolute error between \( f \) and the PWL approximation.}
}
}
\description{
Approximates a continuous function \eqn{f} on a domain \eqn{[a, b]} by
adaptively discretizing the domain and building a piecewise linear (PWL)
envelope until the maximum error between the PWL and \eqn{f} is within a given tolerance.
}
\examples{
f <- function(x) log(x)
domain <- c(1, 10)
res <- adaptive_pwl_fit(f, domain, tol = 1e-4, initial_points = 10, smallconst = 0.01)

cat("x,y\n")
for(i in 1:nrow(res$data)) {
  cat(paste(res$data[i, 1], res$data[i, 2], sep = ","), "\n")
}

}
