% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipysd.R
\name{read_vensim}
\alias{read_vensim}
\title{Loads a Vensim simulation file (mdl)}
\usage{
read_vensim(o, file)
}
\arguments{
\item{o}{is the ipysd S3 object}

\item{file}{is the filename and path for the Vensim mdl file that needs to be simulated}
}
\value{
An S3 object of class ipysd that will contain a reference to the model
}
\description{
\code{read_vensim()} calls \code{pysd.read_vensim()} and stores the object for
further use. This is a key object, as it relates to a model and it can
support a number of functions (e.g. model run, parameter changes)
}
\details{
The result is used as a parameter for simulation calls.

As it's a generic function, this call is dispatched to read_vensim.isdpy
}
\examples{
\dontrun{
target <- system.file("models/vensim", "Population.mdl", package = "pysd2r")
py <- pysd_connect()
read_vensim(py, target)
}
}
