% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_effects.R
\name{conditional_effects_slices}
\alias{conditional_effects_slices}
\title{Discrete-slice conditional effects (brms-style) for qbrms}
\usage{
conditional_effects_slices(
  object,
  effects,
  slices = NULL,
  nslices = 3L,
  prob = 0.95,
  ndraws = 200L,
  at = list(),
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{A qbrms_fit object.}

\item{effects}{Character vector specifying effects to plot. If NULL, all numeric predictors are used.}

\item{slices}{Named list of variables and values at which to slice the data.}

\item{nslices}{Number of slices to use for each slicing variable.}

\item{prob}{Probability mass to include in uncertainty intervals (default 0.95).}

\item{ndraws}{Number of posterior draws to use for predictions.}

\item{at}{Named list of values at which to fix other predictors.}

\item{seed}{Random seed for reproducibility.}

\item{...}{Additional arguments passed to prediction functions.}
}
\value{
An object of class \code{"qbrms_conditional_effects"} containing
a list with one element per effect. Each element is a data frame with
columns for the predictor values, estimates, and credible intervals.
}
\description{
Build point/interval summaries at a few values of a numeric moderator,
plotted against the factor on the x-axis.
}
