% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.2.R
\name{sqr.fit.optim}
\alias{sqr.fit.optim}
\title{Spline Quantile Regression (SQR) by Gradient Algorithms}
\usage{
sqr.fit.optim(
  X,
  y,
  tau,
  spar = 0,
  d = 1,
  weighted = FALSE,
  method = c("BFGS", "ADAM", "GRAD"),
  beta.rq = NULL,
  theta0 = NULL,
  spar0 = NULL,
  sg.rate = c(1, 1),
  mthreads = TRUE,
  control = list(trace = 0)
)
}
\arguments{
\item{X}{vecor or matrix of explanatory variables (including intercept)}

\item{y}{vector of dependent variable}

\item{tau}{sequence of quantile levels in (0,1)}

\item{spar}{smoothing parameter}

\item{d}{subsampling rate of quantile levels (default = 1)}

\item{weighted}{if \code{TRUE}, penalty function is weighted (default = \code{FALSE})}

\item{method}{optimization method: \code{"BFGS"} (default), \code{"ADAM"}, or \code{"GRAD"}}

\item{beta.rq}{matrix of regression coefficients from \code{quantreg::rq(y~X)} for initialization (default = \code{NULL})}

\item{theta0}{initial value of spline coefficients (default = \code{NULL})}

\item{spar0}{smoothing parameter for \code{stats::smooth.spline()} to smooth \code{beta.rq} for initilaiztion (default = \code{NULL})}

\item{sg.rate}{vector of sampling rates for quantiles and observations in stochastic gradient version of GRAD and ADAM}

\item{mthreads}{if \code{FALSE}, set \code{RhpcBLASctl::blas_set_num_threads(1)} (default = \code{TRUE})}

\item{control}{a list of control parameters
\describe{
  \item{\code{maxit}:}{max number of iterations (default = 100)}
  \item{\code{stepsize}:}{stepsize for ADAM and GRAD (default = 0.01)}
  \item{\code{warmup}:}{length of warmup phase for ADAM and GRAD (default = 70)}
  \item{\code{stepupdate}:}{frequency of update for ADAM and GRAD (default = 20)}
  \item{\code{stepredn}:}{stepsize discount factor for ADAM and GRAD (default = 0.2)}
  \item{\code{line.search.type}:}{line search option (1,2,3,4) for GRAD (default = 1)}
  \item{\code{line.search.max}:}{max number of line search trials for GRAD (default = 1)}
  \item{\code{seed}:}{seed for stochastic version of ADAM and GRAD (default = 1000)}
  \item{\code{trace}:}{-1 return results from all iterations, 0 (default) return final result}
}}
}
\value{
A list with the following elements:
  \item{beta}{matrix of regression coefficients}
  \item{all.beta}{coefficients from all iterations for GRAD and ADAM}
  \item{spars}{smoothing parameters from \code{stats::smooth.spline()} for initialization}
  \item{fit}{object from the optimization algorithm}
}
\description{
This function computes spline quantile regression by a gradient algorithm BFGS, ADAM, or GRAD.
}
\examples{
data(engel)
y <- engel$foodexp
X <- cbind(rep(1,length(y)),engel$income-mean(engel$income))
tau <- seq(0.1,0.9,0.05)
fit.rq <- quantreg::rq(y ~ X[,2],tau)
fit.sqr <- sqr(y ~ X[,2],tau,d=2,spar=0.2)
fit <- sqr.fit.optim(X,y,tau,spar=0.2,d=2,method="BFSG",beta.rq=fit.rq$coef)
fit <- sqr.fit.optim(X,y,tau,spar=0.2,d=2,method="BFSG",beta.rq=fit.rq$coef)
par(mfrow=c(1,2),pty="m",lab=c(10,10,2),mar=c(4,4,2,1)+0.1,las=1)
for(j in c(1:2)) {
  plot(tau,fit.rq$coef[j,],type="n",xlab="QUANTILE LEVEL",ylab=paste0("COEFF",j))
  points(tau,fit.rq$coef[j,],pch=1,cex=0.5)
  lines(tau,fit.sqr$coef[j,],lty=1); lines(tau,fit$beta[j,],lty=2,col=2)
}
}
