% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPFISH.R
\name{CPFISH}
\alias{CPFISH}
\title{CPFISH}
\usage{
CPFISH(
  contingency.table,
  control.name = NULL,
  simulate.p.value = TRUE,
  use.fixed.random.seed = NULL,
  show.output = TRUE
)
}
\arguments{
\item{contingency.table}{Matrix with observed data (e.g. survival counts, survival must be in first row)}

\item{control.name}{Character string with control group name (optional)}

\item{simulate.p.value}{Use simulated p-values in Fisher test or not}

\item{use.fixed.random.seed}{Use fixed seed, e.g. 123, for reproducible results. If NULL no seed is set.}

\item{show.output}{Show/hide output}
}
\value{
R object with results and information from CPFISH calculations
}
\description{
For quantal data (e.g. survival data, '14 out of 20 animals died') e.g. in the form of
a contingency table, CPFISH was proposed by Lehmann et al. (2018). Like CPCAT, CPFISH is based on
the Closure Principle (CP), but instead of a bootstrapping approach, a Fisher test is performed for
all sub-hypotheses to be analyzed. For details on the structure of the input table, please refer to
the dataset 'CPFISH.contingency.table' provided alongside this package.
}
\examples{
CPFISH.contingency.table	# example data provided alongside the package

# Test CPFISH
CPFISH(contingency.table = CPFISH.contingency.table,
		control.name = NULL,
		simulate.p.value = TRUE,
		use.fixed.random.seed = 123,  #fixed seed for reproducible results
		show.output = TRUE)
}
\references{
Lehmann, R.; Bachmann, J.; Karaoglan, B.; Lacker, J.; Polleichtner, C.; Ratte, H.; Ratte, M. (2018): An alternative approach to overcome shortcomings with multiple testing of binary data in ecotoxicology. In: Stochastic Environmental Research and Risk Assessment, 2018, 32(1), p. 213-222, https://doi.org/10.1007/s00477-017-1392-1
}
