% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange.R, R/distinct.R, R/dplyr_rows.R,
%   R/filter.R, R/slice.R
\name{arrange}
\alias{arrange}
\alias{distinct}
\alias{dplyr_rows}
\alias{filter}
\alias{slice}
\alias{slice_head}
\alias{slice_tail}
\alias{slice_sample}
\alias{slice_min}
\alias{slice_max}
\title{Verbs that operate on rows}
\arguments{
\item{.data}{a \pkg{quanteda} corpus object}

\item{...}{additional arguments passed to methods}
}
\value{
A corpus, subsetted or reordered according to the operation.
}
\description{
These functions operate on the rows (documents) of \pkg{quanteda} objects,
subsetting, reordering, or selecting distinct documents based on document
variables.
}
\details{
\code{arrange()} orders documents by values of document variables.  See
\code{\link[dplyr:arrange]{dplyr::arrange()}} for more details.

\code{distinct()} subsets documents to keep only unique/distinct rows based on
document variable values. See \code{\link[dplyr:distinct]{dplyr::distinct()}} for more details.

\code{filter()} subsets documents that satisfy specified conditions on document
variables. See \code{\link[dplyr:filter]{dplyr::filter()}} for more details.

\code{slice()} and its variants (\code{slice_head()}, \code{slice_tail()}, \code{slice_min()},
\code{slice_max()}, \code{slice_sample()}) select documents by their (integer)
positions. See \code{\link[dplyr:slice]{dplyr::slice()}} for more details.
}
\keyword{internal}
