% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_quartet_time.R
\docType{data}
\name{causal_collider_time}
\alias{causal_collider_time}
\alias{causal_confounding_time}
\alias{causal_mediator_time}
\alias{causal_m_bias_time}
\alias{causal_quartet_time}
\title{Time-varying Causal Quartet Data}
\format{
\code{causal_collider_time}: A dataframe with 100 rows and 7 variables:
\itemize{
\item \code{covariate_baseline}: known factor measured at baseline
\item \code{exposure_baseline}: exposure measured at baseline
\item \code{outcome_baseline}: outcome measured at baseline
\item \code{exposure_followup}: exposure measured at the followup visit (final time)
\item \code{outcome_followup}: outcome measured at the followup visit (final time)
\item \code{covariate_followup}: known factor measured at the followup visit (final time)
}

\code{causal_confounding_time}: A dataframe with 100 rows and 7 variables:
\itemize{
\item \code{covariate_baseline}: known factor measured at baseline
\item \code{exposure_baseline}: exposure measured at baseline
\item \code{outcome_baseline}: outcome measured at baseline
\item \code{exposure_followup}: exposure measured at the followup visit (final time)
\item \code{outcome_followup}: outcome measured at the followup visit (final time)
\item \code{covariate_followup}: known factor measured at the followup visit (final time)
}

\code{causal_mediator_time}: A dataframe with 100 rows and 7 variables:
\itemize{
\item \code{covariate_baseline}: known factor measured at baseline
\item \code{exposure_baseline}: exposure measured at baseline
\item \code{outcome_baseline}: outcome measured at baseline
\item \code{covariate_mid}: known factor measured at some mid-point
\item \code{exposure_mid}: exposure measured at some mid-point
\item \code{outcome_mid}: outcome measured at some mid-point
\item \code{exposure_followup}: exposure measured at the followup visit (final time)
\item \code{outcome_followup}: outcome measured at the followup visit (final time)
\item \code{covariate_followup}: known factor measured at the followup visit (final time)
}

\code{causal_m_bias_time}: A dataframe with 100 rows and 9 variables:
\itemize{
\item \code{u1}: unmeasured factor
\item \code{u2}: unmeasured factor
\item \code{covariate_baseline}: known factor measured at baseline
\item \code{exposure_baseline}: exposure measured at baseline
\item \code{outcome_baseline}: outcome measured at baseline
\item \code{exposure_followup}: exposure measured at the followup visit (final time)
\item \code{outcome_followup}: outcome measured at the followup visit (final time)
\item \code{covariate_followup}: known factor measured at the followup visit (final time)
}

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 400 rows and 12 columns.
}
\usage{
causal_collider_time

causal_confounding_time

causal_mediator_time

causal_m_bias_time

causal_quartet_time
}
\description{
These datasets contains 100 observations, each generated under a different
data generating mechanism:
\itemize{
\item (1) A collider
\item (2) A confounder
\item (3) A mediator
\item (4) M-bias
}
}
\details{
There are two time points:
\itemize{
\item baseline
\item follow up
}

These datasets help demonstrate that a model that includes only pre-exposure
covariates (that is, only adjusting for covariates measured at baseline), will
be less prone to potential biases. Adjusting for only pre-exposure covariates
"solves" the bias in datasets 1-3. It does not solve the data generated under
the "M-bias" scenario, however this is more of a toy example, it has been
shown many times that the assumptions needed for this M-bias to hold are
often not ones we practically see in data analysis.
}
\examples{

## incorrect model because covariate is post-treatment
lm(outcome_followup ~ exposure_baseline + covariate_followup,
   data = causal_collider_time)

## correct model because covariate is pre-treatment
## even though the true mechanism dictates that the covariate is a collider,
## because the pre-exposure variable is used, the collider bias does not
## occur.
lm(outcome_followup ~ exposure_baseline + covariate_baseline,
   data = causal_collider_time)
}
\references{
D'Agostino McGowan L, Barrett M (2023). Causal inference is not a statistical problem. Preprint arXiv:2304.02683v1.
}
\keyword{datasets}
