/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp.lightgbm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.lightgbm.GBDT;
import org.jpmml.lightgbm.LightGBMUtil;
import org.jpmml.rexp.ModelConverter;
import org.jpmml.rexp.REnvironment;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RRaw;

public class LightGBMConverter
extends ModelConverter<REnvironment> {
    private GBDT gbdt = null;

    public LightGBMConverter(REnvironment environment) {
        super((RExp)environment);
    }

    public void encodeSchema(RExpEncoder encoder) {
        GBDT gbdt = this.ensureGBDT();
        Schema schema = gbdt.encodeSchema(null, null, (ModelEncoder)encoder);
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        encoder.setLabel(label);
        for (Feature feature : features) {
            encoder.addFeature(feature);
        }
    }

    public MiningModel encodeModel(Schema schema) {
        GBDT gbdt = this.ensureGBDT();
        Map options = Collections.emptyMap();
        Schema lgbmSchema = gbdt.toLightGBMSchema(schema);
        return gbdt.encodeModel(options, lgbmSchema);
    }

    private GBDT ensureGBDT() {
        if (this.gbdt == null) {
            this.gbdt = this.loadGBDT();
        }
        return this.gbdt;
    }

    private GBDT loadGBDT() {
        GBDT gBDT;
        REnvironment environment = (REnvironment)this.getObject();
        RRaw raw = (RRaw)environment.findVariable("raw");
        if (raw == null) {
            throw new IllegalArgumentException();
        }
        ByteArrayInputStream is = new ByteArrayInputStream(raw.getValue());
        try {
            gBDT = LightGBMUtil.loadGBDT((InputStream)is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
        ((InputStream)is).close();
        return gBDT;
    }
}

