/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.analysis.components.WorkerComponents;
import com.conveyal.analysis.util.JsonUtil;
import com.conveyal.gtfs.model.Service;
import com.conveyal.r5.analyst.Grid;
import com.conveyal.r5.analyst.WebMercatorExtents;
import com.conveyal.r5.analyst.cluster.PathResult;
import com.conveyal.r5.analyst.decay.ExponentialDecayFunction;
import com.conveyal.r5.analyst.decay.FixedExponentialDecayFunction;
import com.conveyal.r5.analyst.decay.LinearDecayFunction;
import com.conveyal.r5.analyst.decay.LogisticDecayFunction;
import com.conveyal.r5.analyst.decay.StepDecayFunction;
import com.conveyal.r5.analyst.scenario.RoadCongestion;
import com.conveyal.r5.api.util.SearchType;
import com.conveyal.r5.transit.TransportNetwork;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.io.FilenameUtils;
import org.ipea.r5r.Fares.FareStructure;
import org.ipea.r5r.Fares.FareStructureBuilder;
import org.ipea.r5r.Fares.RuleBasedInRoutingFareCalculator;
import org.ipea.r5r.Modifications.R5RFileStorage;
import org.ipea.r5r.Network.NetworkBuilder;
import org.ipea.r5r.Process.AccessibilityEstimator;
import org.ipea.r5r.Process.DetailedItineraryPlanner;
import org.ipea.r5r.Process.FaretoDebug;
import org.ipea.r5r.Process.FastDetailedItineraryPlanner;
import org.ipea.r5r.Process.ParetoFrontierCalculator;
import org.ipea.r5r.Process.ParetoItineraryPlanner;
import org.ipea.r5r.Process.TravelTimeMatrixComputer;
import org.ipea.r5r.RDataFrame;
import org.ipea.r5r.RoutingProperties;
import org.ipea.r5r.Scenario.R5RShapefileLts;
import org.ipea.r5r.Scenario.RoadCongestionOSM;
import org.ipea.r5r.Scenario.SetLtsOsm;
import org.ipea.r5r.SnapFinder;
import org.ipea.r5r.StreetNetwork;
import org.ipea.r5r.TransitNetwork;
import org.ipea.r5r.Utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R5RCore {
    public static final String R5_VERSION = System.getProperty("R5_VER", "7+, ERROR getting exact version");
    public static final String R5R_VERSION = System.getProperty("R5R_VER", "2+, ERROR getting exact version");
    private int numberOfThreads;
    private ForkJoinPool r5rThreadPool;
    private final RoutingProperties routingProperties;
    private final String dataPath;
    private static final Logger LOG = LoggerFactory.getLogger(R5RCore.class);

    public double getWalkSpeed() {
        return this.routingProperties.walkSpeed;
    }

    public void setWalkSpeed(double walkSpeed) {
        this.routingProperties.walkSpeed = walkSpeed;
    }

    public double getBikeSpeed() {
        return this.routingProperties.bikeSpeed;
    }

    public void setBikeSpeed(double bikeSpeed) {
        this.routingProperties.bikeSpeed = bikeSpeed;
    }

    public int getMaxLevelTrafficStress() {
        return this.routingProperties.maxLevelTrafficStress;
    }

    public void setMaxLevelTrafficStress(int maxLevelTrafficStress) {
        this.routingProperties.maxLevelTrafficStress = maxLevelTrafficStress;
    }

    public int getSuboptimalMinutes() {
        return this.routingProperties.suboptimalMinutes;
    }

    public void setSuboptimalMinutes(int suboptimalMinutes) {
        this.routingProperties.suboptimalMinutes = suboptimalMinutes;
    }

    public int getTimeWindowSize() {
        return this.routingProperties.timeWindowSize;
    }

    public void setTimeWindowSize(int timeWindowSize) {
        this.routingProperties.timeWindowSize = timeWindowSize;
    }

    public int getNumberOfMonteCarloDraws() {
        return this.routingProperties.numberOfMonteCarloDraws;
    }

    public void setNumberOfMonteCarloDraws(int numberOfMonteCarloDraws) {
        this.routingProperties.numberOfMonteCarloDraws = numberOfMonteCarloDraws;
    }

    public void setPercentiles(int[] percentiles) {
        this.routingProperties.percentiles = percentiles;
    }

    public void setPercentiles(int percentile) {
        this.routingProperties.percentiles = new int[1];
        this.routingProperties.percentiles[0] = percentile;
    }

    public void setCutoffs(int[] cutoffs) {
        this.routingProperties.cutoffs = cutoffs;
    }

    public void setCutoffs(int cutoff) {
        this.routingProperties.cutoffs = new int[1];
        this.routingProperties.cutoffs[0] = cutoff;
    }

    public void setTravelAllowance(boolean active) {
        ParetoItineraryPlanner.travelAllowanceActive = active;
    }

    public int getMaxRides() {
        return this.routingProperties.maxRides;
    }

    public void setMaxRides(int maxRides) {
        this.routingProperties.maxRides = maxRides;
    }

    public void setExpandedTravelTimes(boolean expandedTravelTimes) {
        this.routingProperties.expandedTravelTimes = expandedTravelTimes;
    }

    public void setSearchType(String searchType) {
        this.routingProperties.searchType = SearchType.valueOf((String)searchType);
    }

    public void setTravelTimesBreakdown(boolean detailedTravelTimes) {
        this.routingProperties.travelTimesBreakdown = detailedTravelTimes;
    }

    public boolean getTravelTimesBreakdown() {
        return this.routingProperties.travelTimesBreakdown;
    }

    public void setTravelTimesBreakdownStat(String stat) {
        if ((stat = stat.toUpperCase()).equals("MIN") | stat.equals("MINIMUM")) {
            this.routingProperties.travelTimesBreakdownStat = PathResult.Stat.MINIMUM;
        }
        if (stat.equals("MEAN") | stat.equals("AVG") | stat.equals("AVERAGE")) {
            this.routingProperties.travelTimesBreakdownStat = PathResult.Stat.MEAN;
        }
    }

    public void setMaxFare(float maxFare) {
        this.routingProperties.maxFare = maxFare >= 0.0f ? maxFare : 2.1474836E9f;
    }

    public void setFareCutoffs(float maxFare) {
        this.routingProperties.maxFare = maxFare;
        this.routingProperties.fareCutoffs = new float[]{maxFare};
    }

    public void setFareCutoffs(float[] maxFare) {
        this.routingProperties.maxFare = maxFare[0];
        this.routingProperties.fareCutoffs = maxFare;
    }

    public void setFareCalculator(String fareCalculatorSettingsJson) {
        this.routingProperties.setFareCalculatorJson(fareCalculatorSettingsJson);
    }

    public void dropFareCalculator() {
        this.routingProperties.fareCalculator = null;
        this.routingProperties.maxFare = -1.0f;
        this.routingProperties.fareCutoffs = new float[]{-1.0f};
    }

    public String getTravelTimesBreakdownStat() {
        return this.routingProperties.travelTimesBreakdownStat.toString();
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
        this.r5rThreadPool = new ForkJoinPool(numberOfThreads);
    }

    public void setNumberOfThreadsToMax() {
        this.r5rThreadPool = ForkJoinPool.commonPool();
        this.numberOfThreads = ForkJoinPool.commonPool().getParallelism();
    }

    public void silentMode() {
        Utils.setLogModeOther("OFF");
        Utils.setLogModeJar("WARN");
    }

    public void verboseMode() {
        Utils.setLogModeOther("INFO");
        Utils.setLogModeJar("INFO");
    }

    public void setProgress(boolean progress) {
        Utils.setlogProgress(progress);
    }

    public void setBenchmark(boolean benchmark) {
        Utils.benchmark = benchmark;
    }

    public void setCsvOutput(String csvFolder) {
        if (!csvFolder.equals("")) {
            Utils.saveOutputToCsv = true;
            Utils.outputCsvFolder = csvFolder;
        } else {
            Utils.saveOutputToCsv = false;
            Utils.outputCsvFolder = "";
        }
    }

    public String getOutputCsvFolder() {
        return Utils.outputCsvFolder;
    }

    public String getLogPath() {
        return System.getProperty("LOG_PATH");
    }

    public void setDetailedItinerariesV2(boolean v2) {
        Utils.detailedItinerariesV2 = v2;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public R5RCore(String dataFolder, boolean verbose, String nativeElevationFunction) throws Exception {
        if (verbose) {
            this.verboseMode();
        } else {
            this.silentMode();
        }
        this.setNumberOfThreadsToMax();
        WorkerComponents.fileStorage = new R5RFileStorage(null);
        nativeElevationFunction = nativeElevationFunction.toUpperCase();
        NetworkBuilder.useNativeElevation = !nativeElevationFunction.equals("NONE");
        NetworkBuilder.elevationCostFunction = nativeElevationFunction;
        this.dataPath = dataFolder;
        Path path = Paths.get(dataFolder, new String[0]).toAbsolutePath().normalize();
        TransportNetwork network = NetworkBuilder.checkAndLoadR5Network(path.toString());
        this.routingProperties = new RoutingProperties(network);
    }

    public RDataFrame detailedItineraries(String fromId, double fromLat, double fromLon, String toId, double toLat, double toLon, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxBikeTime, int maxCarTime, int maxTripDuration, boolean dropItineraryGeometry, boolean shortestPath, boolean osm_link_ids) throws ParseException, ExecutionException, InterruptedException {
        String[] fromIds = new String[]{fromId};
        double[] fromLats = new double[]{fromLat};
        double[] fromLons = new double[]{fromLon};
        String[] toIds = new String[]{toId};
        double[] toLats = new double[]{toLat};
        double[] toLons = new double[]{toLon};
        return this.detailedItineraries(fromIds, fromLats, fromLons, toIds, toLats, toLons, directModes, transitModes, accessModes, egressModes, date, departureTime, maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration, dropItineraryGeometry, shortestPath, osm_link_ids);
    }

    public RDataFrame detailedItineraries(String[] fromIds, double[] fromLats, double[] fromLons, String[] toIds, double[] toLats, double[] toLons, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxBikeTime, int maxCarTime, int maxTripDuration, boolean dropItineraryGeometry, boolean shortestPath, boolean osmLinkIds) throws ExecutionException, InterruptedException {
        if (Utils.detailedItinerariesV2) {
            FastDetailedItineraryPlanner detailedItineraryPlanner = new FastDetailedItineraryPlanner(this.r5rThreadPool, this.routingProperties);
            detailedItineraryPlanner.setOrigins(fromIds, fromLats, fromLons);
            detailedItineraryPlanner.setDestinations(toIds, toLats, toLons);
            detailedItineraryPlanner.setModes(directModes, accessModes, transitModes, egressModes);
            detailedItineraryPlanner.setDepartureDateTime(date, departureTime);
            detailedItineraryPlanner.setTripDuration(maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration);
            if (shortestPath) {
                detailedItineraryPlanner.shortestPathOnly();
            }
            if (dropItineraryGeometry) {
                detailedItineraryPlanner.dropItineraryGeometry();
            }
            if (osmLinkIds) {
                detailedItineraryPlanner.OSMLinkIds();
            }
            RDataFrame out = detailedItineraryPlanner.run();
            this.routingProperties.reset();
            return out;
        }
        DetailedItineraryPlanner detailedItineraryPlanner = new DetailedItineraryPlanner(this.r5rThreadPool, this.routingProperties);
        detailedItineraryPlanner.setOrigins(fromIds, fromLats, fromLons);
        detailedItineraryPlanner.setDestinations(toIds, toLats, toLons);
        detailedItineraryPlanner.setModes(directModes, accessModes, transitModes, egressModes);
        detailedItineraryPlanner.setDepartureDateTime(date, departureTime);
        detailedItineraryPlanner.setTripDuration(maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration);
        if (dropItineraryGeometry) {
            detailedItineraryPlanner.dropItineraryGeometry();
        }
        RDataFrame out = detailedItineraryPlanner.run();
        this.routingProperties.reset();
        return out;
    }

    public RDataFrame travelTimeMatrix(String fromId, double fromLat, double fromLon, String[] toIds, double[] toLats, double[] toLons, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxBikeTime, int maxCarTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        String[] fromIds = new String[]{fromId};
        double[] fromLats = new double[]{fromLat};
        double[] fromLons = new double[]{fromLon};
        return this.travelTimeMatrix(fromIds, fromLats, fromLons, toIds, toLats, toLons, directModes, transitModes, accessModes, egressModes, date, departureTime, maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration);
    }

    public RDataFrame travelTimeMatrix(String[] fromIds, double[] fromLats, double[] fromLons, String toId, double toLat, double toLon, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxBikeTime, int maxCarTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        String[] toIds = new String[]{toId};
        double[] toLats = new double[]{toLat};
        double[] toLons = new double[]{toLon};
        return this.travelTimeMatrix(fromIds, fromLats, fromLons, toIds, toLats, toLons, directModes, transitModes, accessModes, egressModes, date, departureTime, maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration);
    }

    public RDataFrame travelTimeMatrix(String fromId, double fromLat, double fromLon, String toId, double toLat, double toLon, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxBikeTime, int maxCarTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        String[] fromIds = new String[]{fromId};
        double[] fromLats = new double[]{fromLat};
        double[] fromLons = new double[]{fromLon};
        String[] toIds = new String[]{toId};
        double[] toLats = new double[]{toLat};
        double[] toLons = new double[]{toLon};
        return this.travelTimeMatrix(fromIds, fromLats, fromLons, toIds, toLats, toLons, directModes, transitModes, accessModes, egressModes, date, departureTime, maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration);
    }

    public RDataFrame travelTimeMatrix(String[] fromIds, double[] fromLats, double[] fromLons, String[] toIds, double[] toLats, double[] toLons, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxBikeTime, int maxCarTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        TravelTimeMatrixComputer travelTimeMatrixComputer = new TravelTimeMatrixComputer(this.r5rThreadPool, this.routingProperties);
        travelTimeMatrixComputer.setOrigins(fromIds, fromLats, fromLons);
        travelTimeMatrixComputer.setDestinations(toIds, toLats, toLons);
        travelTimeMatrixComputer.setModes(directModes, accessModes, transitModes, egressModes);
        travelTimeMatrixComputer.setDepartureDateTime(date, departureTime);
        travelTimeMatrixComputer.setTripDuration(maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration);
        RDataFrame out = travelTimeMatrixComputer.run();
        this.routingProperties.reset();
        return out;
    }

    public RDataFrame paretoFrontier(String fromId, double fromLat, double fromLon, String[] toIds, double[] toLats, double[] toLons, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxBikeTime, int maxCarTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        String[] fromIds = new String[]{fromId};
        double[] fromLats = new double[]{fromLat};
        double[] fromLons = new double[]{fromLon};
        return this.paretoFrontier(fromIds, fromLats, fromLons, toIds, toLats, toLons, directModes, transitModes, accessModes, egressModes, date, departureTime, maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration);
    }

    public RDataFrame paretoFrontier(String[] fromIds, double[] fromLats, double[] fromLons, String toId, double toLat, double toLon, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxBikeTime, int maxCarTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        String[] toIds = new String[]{toId};
        double[] toLats = new double[]{toLat};
        double[] toLons = new double[]{toLon};
        return this.paretoFrontier(fromIds, fromLats, fromLons, toIds, toLats, toLons, directModes, transitModes, accessModes, egressModes, date, departureTime, maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration);
    }

    public RDataFrame paretoFrontier(String fromId, double fromLat, double fromLon, String toId, double toLat, double toLon, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxBikeTime, int maxCarTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        String[] fromIds = new String[]{fromId};
        double[] fromLats = new double[]{fromLat};
        double[] fromLons = new double[]{fromLon};
        String[] toIds = new String[]{toId};
        double[] toLats = new double[]{toLat};
        double[] toLons = new double[]{toLon};
        return this.paretoFrontier(fromIds, fromLats, fromLons, toIds, toLats, toLons, directModes, transitModes, accessModes, egressModes, date, departureTime, maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration);
    }

    public RDataFrame paretoFrontier(String[] fromIds, double[] fromLats, double[] fromLons, String[] toIds, double[] toLats, double[] toLons, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxBikeTime, int maxCarTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        ParetoFrontierCalculator paretoFrontierCalculator = new ParetoFrontierCalculator(this.r5rThreadPool, this.routingProperties);
        paretoFrontierCalculator.setOrigins(fromIds, fromLats, fromLons);
        paretoFrontierCalculator.setDestinations(toIds, toLats, toLons);
        paretoFrontierCalculator.setModes(directModes, accessModes, transitModes, egressModes);
        paretoFrontierCalculator.setDepartureDateTime(date, departureTime);
        paretoFrontierCalculator.setTripDuration(maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration);
        RDataFrame out = paretoFrontierCalculator.run();
        this.routingProperties.reset();
        return out;
    }

    public String faretoJson(String fromId, double fromLat, double fromLon, String toId, double toLat, double toLon, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxBikeTime, int maxCarTime, int maxTripDuration) throws ExecutionException, InterruptedException, JsonProcessingException {
        FaretoDebug calculator = new FaretoDebug(this.r5rThreadPool, this.routingProperties);
        calculator.setOrigins(new String[]{fromId}, new double[]{fromLat}, new double[]{fromLon});
        calculator.setDestinations(new String[]{toId}, new double[]{toLat}, new double[]{toLon});
        calculator.setModes(directModes, accessModes, transitModes, egressModes);
        calculator.setDepartureDateTime(date, departureTime);
        calculator.setTripDuration(maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration);
        calculator.run();
        this.routingProperties.reset();
        return JsonUtil.objectMapper.writeValueAsString((Object)calculator.pathResults);
    }

    public RDataFrame accessibility(String[] fromIds, double[] fromLats, double[] fromLons, String[] toIds, double[] toLats, double[] toLons, String[] opportunities, int[][] opportunityCounts, String decayFunction, double decayValue, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxBikeTime, int maxCarTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        AccessibilityEstimator accessibilityEstimator = new AccessibilityEstimator(this.r5rThreadPool, this.routingProperties);
        accessibilityEstimator.setOrigins(fromIds, fromLats, fromLons);
        accessibilityEstimator.setDestinations(toIds, toLats, toLons, opportunities, opportunityCounts);
        accessibilityEstimator.setDecayFunction(decayFunction, decayValue);
        accessibilityEstimator.setModes(directModes, accessModes, transitModes, egressModes);
        accessibilityEstimator.setDepartureDateTime(date, departureTime);
        accessibilityEstimator.setTripDuration(maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration);
        RDataFrame out = accessibilityEstimator.run();
        this.routingProperties.reset();
        return out;
    }

    public double[] testDecay(String decayFunctionName, double decayValue) {
        StepDecayFunction decayFunction = null;
        if ((decayFunctionName = decayFunctionName.toUpperCase()).equals("STEP")) {
            decayFunction = new StepDecayFunction();
        }
        if (decayFunctionName.equals("EXPONENTIAL")) {
            decayFunction = new ExponentialDecayFunction();
        }
        if (decayFunctionName.equals("FIXED_EXPONENTIAL")) {
            decayFunction = new FixedExponentialDecayFunction();
            ((FixedExponentialDecayFunction)decayFunction).decayConstant = decayValue;
        }
        if (decayFunctionName.equals("LINEAR")) {
            decayFunction = new LinearDecayFunction();
            ((LinearDecayFunction)decayFunction).widthMinutes = (int)decayValue;
        }
        if (decayFunctionName.equals("LOGISTIC")) {
            decayFunction = new LogisticDecayFunction();
            ((LogisticDecayFunction)decayFunction).standardDeviationMinutes = decayValue;
        }
        if (decayFunction != null) {
            decayFunction.prepare();
            double[] decay = new double[3600];
            for (int i = 0; i < 3600; ++i) {
                decay[i] = decayFunction.computeWeight(1800, i + 1);
            }
            return decay;
        }
        return null;
    }

    public RDataFrame findSnapPoints(String fromId, double fromLat, double fromLon, double radius, String mode) throws ExecutionException, InterruptedException {
        String[] fromIds = new String[]{fromId};
        double[] fromLats = new double[]{fromLat};
        double[] fromLons = new double[]{fromLon};
        return this.findSnapPoints(fromIds, fromLats, fromLons, radius, mode);
    }

    public RDataFrame findSnapPoints(String[] fromId, double[] fromLat, double[] fromLon, double radius, String mode) throws ExecutionException, InterruptedException {
        SnapFinder snapFinder = new SnapFinder(this.r5rThreadPool, this.routingProperties.getTransportNetworkBase());
        snapFinder.setOrigins(fromId, fromLat, fromLon);
        snapFinder.setRadius(radius);
        snapFinder.setMode(mode);
        return snapFinder.run();
    }

    public RDataFrame getGrid(int resolution) {
        return this.getGrid(resolution, true);
    }

    public RDataFrame getGrid(int resolution, boolean dropGeometry) {
        Grid gridPointSet = new Grid(resolution, this.routingProperties.getTransportNetworkBase().getEnvelope());
        RDataFrame gridTable = new RDataFrame(gridPointSet.featureCount());
        gridTable.addStringColumn("id", "");
        gridTable.addDoubleColumn("lat", 0.0);
        gridTable.addDoubleColumn("lon", 0.0);
        if (!dropGeometry) {
            gridTable.addStringColumn("geometry", "");
        }
        for (int index = 0; index < gridPointSet.featureCount(); ++index) {
            int x = index % gridPointSet.extents.width;
            int y = index / gridPointSet.extents.width;
            gridTable.append();
            gridTable.set("id", String.valueOf(index));
            gridTable.set("lat", Grid.pixelToCenterLat((int)(y + gridPointSet.extents.north), (int)resolution));
            gridTable.set("lon", Grid.pixelToCenterLon((int)(x + gridPointSet.extents.west), (int)resolution));
            if (dropGeometry) continue;
            gridTable.set("geometry", Grid.getPixelGeometry((int)(x + gridPointSet.extents.west), (int)(y + gridPointSet.extents.north), (WebMercatorExtents)gridPointSet.extents).toString());
        }
        return gridTable;
    }

    public String applyCongestionPolygon(String filePath, String scalingAttribute, String priorityAttribute, String nameAttribute, float defaultScaling) {
        Path fileJPath = Paths.get(filePath, new String[0]).toAbsolutePath().normalize();
        RoadCongestion congestion = new RoadCongestion();
        congestion.polygonLayer = fileJPath.toString();
        congestion.scalingAttribute = scalingAttribute;
        congestion.priorityAttribute = priorityAttribute;
        congestion.nameAttribute = nameAttribute;
        congestion.defaultScaling = defaultScaling;
        congestion.resolve(this.routingProperties.transportNetworkWorking);
        congestion.apply(this.routingProperties.transportNetworkWorking);
        return congestion.errors.toString();
    }

    public String applyLtsPolygon(String filePath) {
        Path fileJPath = Paths.get(filePath, new String[0]).toAbsolutePath().normalize();
        R5RShapefileLts lts = new R5RShapefileLts();
        lts.dataSourceId = FilenameUtils.removeExtension((String)fileJPath.toString());
        lts.resolve(this.routingProperties.transportNetworkWorking);
        lts.apply(this.routingProperties.transportNetworkWorking);
        return lts.errors.toString();
    }

    public String applyCongestionOsm(HashMap<Long, Float> speedMap, float defaultScaling, boolean absoluteMode) {
        RoadCongestionOSM congestion = new RoadCongestionOSM();
        congestion.speedMap = speedMap;
        congestion.defaultScaling = defaultScaling;
        congestion.absoluteMode = absoluteMode;
        congestion.resolve(this.routingProperties.transportNetworkWorking);
        congestion.apply(this.routingProperties.transportNetworkWorking);
        return congestion.errors.toString();
    }

    public String applyLtsOsm(HashMap<Long, Integer> ltsMap) {
        SetLtsOsm lts = new SetLtsOsm();
        lts.ltsMap = ltsMap;
        lts.resolve(this.routingProperties.transportNetworkWorking);
        lts.apply(this.routingProperties.transportNetworkWorking);
        return lts.errors.toString();
    }

    public List<RDataFrame> getStreetNetwork() {
        StreetNetwork streetNetwork = new StreetNetwork(this.routingProperties.transportNetworkWorking);
        ArrayList<RDataFrame> transportNetworkList = new ArrayList<RDataFrame>();
        transportNetworkList.add(streetNetwork.verticesTable);
        transportNetworkList.add(streetNetwork.edgesTable);
        return transportNetworkList;
    }

    public List<RDataFrame> getTransitNetwork() {
        TransitNetwork transitNetwork = new TransitNetwork(this.routingProperties.getTransportNetworkBase());
        ArrayList<RDataFrame> transportNetworkList = new ArrayList<RDataFrame>();
        transportNetworkList.add(transitNetwork.routesTable);
        transportNetworkList.add(transitNetwork.stopsTable);
        return transportNetworkList;
    }

    public FareStructure buildFareStructure(float baseFare, String type) {
        FareStructureBuilder builder = new FareStructureBuilder(this.routingProperties.getTransportNetworkBase());
        type = type.toUpperCase();
        return builder.build(baseFare, type);
    }

    public String getFareStructure() {
        String json = "";
        if (this.routingProperties.fareCalculator != null) {
            json = ((RuleBasedInRoutingFareCalculator)this.routingProperties.fareCalculator).getFareStructure().toJson();
        }
        return json;
    }

    public RDataFrame paretoItineraries(String fromId, double fromLat, double fromLon, String toId, double toLat, double toLon, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxBikeTime, int maxCarTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        String[] fromIds = new String[]{fromId};
        double[] fromLats = new double[]{fromLat};
        double[] fromLons = new double[]{fromLon};
        String[] toIds = new String[]{toId};
        double[] toLats = new double[]{toLat};
        double[] toLons = new double[]{toLon};
        return this.paretoItineraries(fromIds, fromLats, fromLons, toIds, toLats, toLons, directModes, transitModes, accessModes, egressModes, date, departureTime, maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration);
    }

    public RDataFrame paretoItineraries(String[] fromIds, double[] fromLats, double[] fromLons, String[] toIds, double[] toLats, double[] toLons, String directModes, String transitModes, String accessModes, String egressModes, String date, String departureTime, int maxWalkTime, int maxBikeTime, int maxCarTime, int maxTripDuration) throws ExecutionException, InterruptedException {
        ParetoItineraryPlanner paretoFrontierCalculator = new ParetoItineraryPlanner(this.r5rThreadPool, this.routingProperties);
        paretoFrontierCalculator.setOrigins(fromIds, fromLats, fromLons);
        paretoFrontierCalculator.setDestinations(toIds, toLats, toLons);
        paretoFrontierCalculator.setModes(directModes, accessModes, transitModes, egressModes);
        paretoFrontierCalculator.setDepartureDateTime(date, departureTime);
        paretoFrontierCalculator.setTripDuration(maxWalkTime, maxBikeTime, maxCarTime, maxTripDuration);
        RDataFrame out = paretoFrontierCalculator.run();
        this.routingProperties.reset();
        return out;
    }

    public RDataFrame getTransitServicesByDate(String date) {
        RDataFrame servicesTable = new RDataFrame();
        servicesTable.addStringColumn("service_id", "");
        servicesTable.addStringColumn("start_date", "");
        servicesTable.addStringColumn("end_date", "");
        servicesTable.addBooleanColumn("active_on_date", false);
        for (Service service : this.routingProperties.getTransportNetworkBase().transitLayer.services) {
            servicesTable.append();
            servicesTable.set("service_id", service.service_id);
            if (service.calendar != null) {
                servicesTable.set("start_date", String.valueOf(service.calendar.start_date));
                servicesTable.set("end_date", String.valueOf(service.calendar.end_date));
            }
            servicesTable.set("active_on_date", service.activeOn(LocalDate.parse(date)));
        }
        return servicesTable;
    }

    public boolean hasFrequencies() {
        return this.routingProperties.getTransportNetworkBase().transitLayer.hasFrequencies;
    }

    public void abort() {
        LOG.error("process aborted");
    }

    public String identify() {
        return "I am an R5R core!";
    }
}

