% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_snap.R
\name{find_snap}
\alias{find_snap}
\title{Find snapped locations of input points on street network}
\usage{
find_snap(
  r5r_network,
  r5r_core = deprecated(),
  points,
  radius = 1600,
  mode = "WALK"
)
}
\arguments{
\item{r5r_network}{A routable transport network created with \code{\link[=build_network]{build_network()}}.}

\item{r5r_core}{The \code{r5r_core} argument is deprecated as of r5r v2.3.0.
Please use the \code{r5r_network} argument instead.}

\item{points}{Either a \verb{POINT sf} object with WGS84 CRS, or a \code{data.frame}
containing the columns \code{id}, \code{lon} and \code{lat}.}

\item{radius}{Numeric. The maximum radius in meters within which to snap.
Defaults to 1600m.}

\item{mode}{A string. Which mode to consider when trying to snap the points
to the network. Defaults to \code{WALK}, also allows \code{BICYCLE} and \code{CAR}.}
}
\value{
A \code{data.table} with the original points, their respective
snapped coordinates on the street network and the Euclidean distance (in
meters) between the original points and their snapped location. Points that
could not be snapped show \code{NA} coordinates and \code{found = FALSE}.
}
\description{
Finds the snapped location of points on \code{R5} network. Snapping is an
important step of the routing process, which is when the origins and
destinations specified by the user are actually positioned on the network
created by \code{R5}. The snapping process in \code{R5} is composed of two rounds.
First, it tries to snap the points within a radius of 300 meters from
themselves. If the first round is unsuccessful, then \code{R5} expands the search
to the radius specified (by default 1.6km). If yet again it is unsuccessful,
then the unsnapped points won't be used during the routing process. The
snapped location of each point depends on the transport mode set by the user,
because some network edges are not available to specific modes (e.g. a
pedestrian-only street cannot be used to snap car trips).
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(r5r)

path <- system.file("extdata/poa", package = "r5r")
r5r_network <- build_network(data_path = path)
points <- read.csv(file.path(path, "poa_hexgrid.csv"))

snap_df <- find_snap(
  r5r_network,
  points = points,
  radius = 2000,
  mode = "WALK"
  )

stop_r5(r5r_network)
\dontshow{\}) # examplesIf}
}
\seealso{
Other network functions: 
\code{\link{street_network_to_sf}()},
\code{\link{transit_network_to_sf}()}
}
\concept{network functions}
