% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.3_Factorial_designs_Functions.R
\name{starDesign}
\alias{starDesign}
\title{starDesign: Axial Design}
\usage{
starDesign(
  k,
  p = 0,
  alpha = c("both", "rotatable", "orthogonal"),
  cs,
  cc,
  data
)
}
\arguments{
\item{k}{Integer value giving number of factors.}

\item{p}{Integer value giving the number of factors via aliasing.
By default set to `0`.}

\item{alpha}{If no numeric value is given defaults to \code{`both`} i.e. \code{`orthogonality`} and \code{`rotatibility`} which can be set as character strings too.}

\item{cs}{Integer value giving the number of centerpoints in the star portion of the design.}

\item{cc}{Integer value giving the number of centerpoints in the cube portion of the design.}

\item{data}{Optional. An object of class \code{\link{facDesign.c}}.}
}
\value{
\code{starDesign} returns a \code{facDesign.c} object if an object of class \code{facDesign.c} is given or a list containing entries for axial runs and center points in the cube and the star portion of a design.
}
\description{
\code{starDesign} is a function to create the star portion of a response surface design. The starDesign function can be used to create a star portion of a response surface design for a sequential assembly strategy.
One can either specify k and p and alpha and cs and cc OR simply simply pass an object of class \code{\link{facDesign.c}} to the data. In the latter an object of class \code{\link{facDesign.c}} otherwise a list containing the axial runs and centerpoints is returned.
}
\examples{
# Example 1: sequential assembly
# Factorial design with one center point in the cube portion
fdo = facDesign(k = 3, centerCube = 1)
# Set the response via generic response method
fdo$.response(1:9)
# Sequential assembly of a response surface design (rsd)
rsd = starDesign(data = fdo)

# Example 2: Returning a list of star point designs
starDesign(k = 3, cc = 2, cs = 2, alpha = "orthogonal")
starDesign(k = 3, cc = 2, cs = 2, alpha = "rotatable")
starDesign(k = 3, cc = 2, cs = 2, alpha = "both")
}
\seealso{
\code{\link{facDesign}}, \code{\link{fracDesign}}, \code{\link{rsmDesign}}, \code{\link{mixDesign}}
}
