% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immunogenicity_functions.R
\docType{methods}
\name{calcCvStats}
\alias{calcCvStats}
\alias{calcCvStats,ImmunoAssay-method}
\title{Calculate Coefficient of Variation}
\usage{
calcCvStats(assay.obj, cv.threshold = 20)
}
\arguments{
\item{assay.obj}{An ImmunoAssay object imported by importAssay}

\item{cv.threshold}{Threshold for re-calculation of means and standard deviation based on coefficient of variation. The default threshold is 20 (i.e., 20\% CV)}
}
\value{
An object of the class ImmunoAssay with calculated CV stats in the \code{cv.table} slot
}
\description{
The function calculates the mean, standard deviation and coefficient of variation for replicates of an immunoassay.
}
\examples{

assay.obj <- importAssay(lognormAssay)
assay.obj <- calcCvStats(assay.obj)
}
\author{
Emma Gail
}
