% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/immunogenicity_functions.R
\name{calcScpValues}
\alias{calcScpValues}
\title{Calculate screening cut point values for scp()}
\usage{
calcScpValues(
  assay.values,
  conf.level = 0.95,
  distrib = c("nonparametric", "normal"),
  transf.method = c("log10", "ln")
)
}
\arguments{
\item{assay.values}{List of selected values from the assay data.frame such as selected values from assayMelt()}

\item{conf.level}{Decimal describing level of confidence to be used for confidence interval calculation. Defaults to 0.95}

\item{distrib}{Distribution selection to determine the cut point calculation. Two options: 'nonparametric' or 'normal'}

\item{transf.method}{Transformation method used. The inverse will be calculated as part of the output.}
}
\value{
A data.frame cotaining the values: "mean", "sd", "distrib", "cp", "mean.conf.int1", "mean.conf.int2", "cp.conf.int1", "cp.conf.int2"
}
\description{
This function calculates the values needed for the output of the scp() data.frame
}
\examples{

assay.df.melted <- assayMelt(assay.df = lognormAssay, exp.name = 'Experiment1')
assay.values <- assay.df.melted[assay.df.melted$DayOperator == 'D1Op1',]$value
#This function assumes that the data has already been transformed.
scp.df <- calcScpValues(assay.values = log10(assay.values), distrib = 'normal',
transf.method = 'log10')



}
\author{
Emma Gail
}
