% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_venv.R
\name{create_cissvae_env}
\alias{create_cissvae_env}
\title{Create or reuse a CISSVAE Python virtual environment}
\usage{
create_cissvae_env(
  envname = "cissvae_environment",
  path = NULL,
  install_python = FALSE,
  python_version = "3.10"
)
}
\arguments{
\item{envname}{Name of the virtual environment (when using the default env location).}

\item{path}{Character; optional path to the directory in which to create/use the virtualenv.}

\item{install_python}{Logical; if TRUE, install Python if none of at least the requested
version is found on the system.}

\item{python_version}{Python version string (major.minor), used when installing Python.}
}
\value{
NULL. Does not return anything
}
\description{
This function will either find an existing virtualenv by name (in
the default location) or at a custom filesystem path, or create it
(and install CISSVAE into it).
}
\examples{
\donttest{
## Requires a working Python environment via reticulate
## Examples are wrapped in try() to avoid failures on CRAN check systems
try({
create_cissvae_env(
envname = "cissvae_environment",
install_python = FALSE,
python_version = "3.10")})}

}
