% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strava_oauth.R
\name{strava_oauth}
\alias{strava_oauth}
\title{Generata Strava API authentication token}
\usage{
strava_oauth(
  app_name,
  app_client_id,
  app_secret,
  app_scope = c("public", "read", "read_all", "profile:read_all", "profile:write",
    "activity:read", "activity:read_all", "activity:write"),
  cache = TRUE
)
}
\arguments{
\item{app_name}{chr string for name of the app}

\item{app_client_id}{chr string for ID received when the app was registered}

\item{app_secret}{chr string for secret received when the app was registered}

\item{app_scope}{chr string for scope of authentication, Must be one of "public", "read" , "read_all", "profile:read_all", "profile:write", "activity:read", "activity:read_all" or "activity:write"}

\item{cache}{logical to cache the token, default is set}
}
\value{
A \code{Token2.0} object returned by \code{\link[httr]{oauth2.0_token}} to be used with API function calls
}
\description{
Generate a token for the user and the desired scope. The user is sent to the strava authentication page if he/she hasn't given permission to the app yet, else, is sent to the app webpage.
}
\details{
The \code{app_name}, \code{app_client_id}, and \code{app_secret} are specific to the user and can be obtained by registering an app on the Strava API authentication page: \url{http://strava.github.io/api/v3/oauth/}.  This requires a personal Strava account.
}
\examples{
\dontrun{
app_name <- 'myappname' # chosen by user
app_client_id  <- 'myid' # an integer, assigned by Strava
app_secret <- 'xxxxxxxx' # an alphanumeric secret, assigned by Strava

# create the authentication token
stoken <- httr::config(
  token = strava_oauth(
    app_name, 
    app_client_id, 
    app_secret, 
    app_scope="activity:read_all"
  )
)

# use authentication token
get_athlete(stoken, id = '2837007')
}
}
\concept{token}
