% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_voxels.R
\name{summary_voxels}
\alias{summary_voxels}
\title{Voxels Summary}
\usage{
summary_voxels(voxels, edge_length = NULL, bootstrap = FALSE, R = NULL)
}
\arguments{
\item{voxels}{An object of class \code{voxels} created using the \code{voxels()} function or a \code{data.table} describing the voxels coordinates and their number of points produced using \code{voxels()}.}

\item{edge_length}{A positive \code{numeric} vector with the voxel-edge length for the x, y, and z coordinates. This need to be used if \code{class(voxels) != "voxels"}. It use the same dimensional scale of the point cloud.}

\item{bootstrap}{Logical, if \code{TRUE} it computes a bootstrap on the H index calculations. \code{FALSE} as default.}

\item{R}{A positive \code{integer} of length 1 indicating the number of bootstrap replicates. This need to be used if \code{bootstrap = TRUE}.}
}
\value{
A \code{data.table} with with the summary of \code{voxels}.
}
\description{
Create a summary objects of class \code{"voxels"} created using the \code{\link{voxels}}.
}
\details{
The function provides 12 main statistics of the voxels. Specifically, the first three columns represent the edge length of the voxels, the following three columns (ei. \code{N_voxels}, \code{Volume}, \code{Surface}) describe the number of voxels created, the total volume that they represent, and the surface area that they cover.
Following columns represent the mean (\code{Density_mean}) and sd (\code{Density_sd}) of the density of points per voxel (e.g. points/m2). Columns 9:12 provide metrics calculated using the Shannon Index. Specifically, \code{H} describe the entropy, \code{H_max} the maximum entropy, \code{Equitavility} the ratio between \code{H} and \code{Hmax}, and \code{Negentropy} describe the product of \code{Hmax} - \code{H}.
If \code{bootstrap = TRUE} four more columns are created (13:16). These represent the \code{mean} and \code{sd} of the H index estimated using bootstrap (\code{H_boot_mean} and \code{H_boot_sd}), the \code{Equtavility_boot} as the ratio of the ratio between \code{H_boot_sd} and \code{Hmax}, and \code{Negentropy_boot} as the product \code{Hmax} - \code{H_boot_mean}.
}
\examples{
data("pc_tree")

#Apply a summary on a object of class "voxels" using bootstrap with 1000 replicates.
vox <- voxels(pc_tree, edge_length = c(0.5, 0.5, 0.5))
summary_voxels(vox, bootstrap = TRUE, R = 1000)

#Apply a summary on a product from 'voxels' using bootstrap with 1000 replicates.
vox <- voxels(pc_tree, edge_length = c(0.5, 0.5, 0.5), obj.voxels = FALSE)
summary_voxels(vox, edge_length = c(0.5, 0.5, 0.5), bootstrap = TRUE, R = 1000)

}
\seealso{
\code{\link{voxels}}, \code{\link{voxels_counting}}, \code{\link{plot_voxels}}
}
\author{
J. Antonio Guzmán Q.
}
