% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_validation_classes.R
\name{get_validation_classes}
\alias{get_validation_classes}
\title{Tree-level damage classes for validation datasets}
\usage{
get_validation_classes(file_path)
}
\arguments{
\item{file_path}{A character string indicating the path to the validation folders, one for each class.
This folder must have sub folders with samples for each class.}
}
\value{
Returns the classes based on file names in a given folder.
}
\description{
This function return the post-hurricane individual tree-level damage classes based on file names in a given directory.
}
\examples{
# Image and model properties
val_image_files_path = system.file('extdata', 'validation', package='rTLsDeep')

# Get damage classes for validation datasets
classes = get_validation_classes(file_path=val_image_files_path)

}
