% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_offdefsc.R
\name{offdefsc}
\alias{offdefsc}
\title{Kleinberg's HITS algorithm for Rating and Ranking with Square Matrix}
\usage{
offdefsc(
  jpMat,
  method = "hitspp",
  totalsupporteps = 0,
  totalsupporttype = 1,
  numiter = 100,
  ties.method = "average"
)
}
\arguments{
\item{jpMat}{a Judge-Presenter matrix, or a User-Movie matrix}

\item{method}{a character string specifying the HITS algorithm, including "hitspp".}

\item{totalsupporteps}{a small number to guarantee the total support property}

\item{totalsupporttype}{an indicater: 1 stands for matrix ee^T and 2 stands for matrix ee^T - I}

\item{numiter}{a number of iterations}

\item{ties.method}{a character string specifying how ties are treated, including "average", "first", "last", "random", "max", "min", from base::rank}
}
\description{
Calculate ratings and provide rankings using Kleinberg's HITS algorithm, using a square matrix for score matrix (presenter-presenter)
}
\details{
Large offense score means strong offense, and large defense score means weak defense
\enumerate{
\item \code{hitspp}: HITS, using presenter-presenter matrix, equivalent to \code{offdefsc}
\item \code{offdefsc}: Offense-Defense rating method, using presenter-presenter matrix
}
}
\examples{
jpMat <- matrix(data=c(5,4,3,0, 5,5,3,1, 0,0,0,5, 0,0,2,0, 4,0,0,3, 1,0,0,4),nrow=6,byrow=TRUE)
 method <- 'hitspp'
totalsupporteps <- 0.01
totalsupporttype <- 1
numiter <- 10
ties.method <-'average'
result <- offdefsc(jpMat, method, totalsupporteps, totalsupporttype, numiter, ties.method)
print(result)
}
\references{
Gou, J. and Wu, S. (2020). A Judging System for Project Showcase: Rating and Ranking with Incomplete Information. Technical Report.

Kleinberg, J. M. (1999). Authoritative sources in a hyperlinked environment. Journal of the ACM 46, 604-632.

Langville, A. N. and Meyer, C. D. (2012). Who's Number 1?: The Science of Rating and Ranking. Princeton University Press.
}
\author{
Jiangtao Gou
}
