% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdt_data.r
\name{rdt_data}
\alias{rdt_data}
\alias{rdt_data.numeric}
\alias{rdt_data.data.frame}
\title{Get data for the Kornbrot rank difference test.}
\usage{
rdt_data(x, ...)

\method{rdt_data}{numeric}(x, y, x_name, y_name, ...)

\method{rdt_data}{data.frame}(x, formula, agg_fun = "error", ...)
}
\arguments{
\item{x}{(numeric)\cr
Numeric vector or data.frame of data.
If numeric, differences of ranks correspond with \code{x - y}.
Pairs with missing values are silently dropped.}

\item{...}{Unused additional arguments.}

\item{y}{(numeric)\cr
Numeric vector of data.
Differences of ranks correspond with \code{x - y}.
Pairs with missing values are silently dropped.}

\item{x_name}{(Scalar character)\cr
Name of \code{x} variable.}

\item{y_name}{(Scalar character)\cr
Name of \code{y} variable.}

\item{formula}{(formula)\cr
A formula of form:
\describe{
\item{y ~ group | block}{
Use when \code{data} is in tall format.
\code{y} is the numeric outcome, \code{group} is the binary grouping variable, and \code{block} is the subject/item-level variable indicating pairs of observations.
\code{group} will be converted to a factor and the first level will be the reference value.
For example, when \code{levels(data$group) <- c("pre", "post")}, the focal level is 'post', so differences are \code{post - pre}.
Pairs with missing values are silently dropped.
See \code{agg_fun} for handling duplicate cases of grouping/blocking combinations.
}
\item{y ~ x}{
Use when \code{data} is in wide format.
\code{y} and \code{x} must be numeric vectors.
Differences of ranks correspond with \code{data$y - data$x}.
Pairs with missing values are silently dropped.
}
}}

\item{agg_fun}{(Scalar character or function: \code{"error"})\cr
Used for aggregating duplicate cases of grouping/blocking combinations when data is in tall format and \code{formula} has structure \code{y ~ group | block}.
\code{"error"} (default) will return an error if duplicate grouping/blocking combinations are encountered.
Select one of \code{"first"}, \code{"last"}, \code{"sum"}, \code{"mean"}, \code{"median"}, \code{"min"}, or \code{"max"} for built in aggregation handling (each applies \code{na.rm = TRUE}).
Or define your own function.
For example, \code{myfun <- function(x) {as.numeric(quantile(x, 0.75, na.rm = TRUE))}}.}
}
\value{
list
}
\description{
Gets data needed to compute Kornbrot rank difference results.
The returned list is designed to be reused by higher-level functions.
}
\keyword{internal}
