% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apl_get_keyword_report.R
\name{apl_get_keyword_report}
\alias{apl_get_keyword_report}
\title{Get Keyword-Level Reports}
\usage{
apl_get_keyword_report(
  org_id = apl_get_me_details()$parentOrgId,
  campaign_id = apl_get_campaigns()$id,
  start_date = Sys.Date() - 8,
  end_date = Sys.Date() - 1,
  group_by = NULL,
  granularity = c("DAILY", "HOURLY", "WEEKLY", "MONTHLY")
)
}
\arguments{
\item{org_id}{The value is your orgId.}

\item{campaign_id}{The unique identifier for the campaign.}

\item{start_date}{Start reporting date}

\item{end_date}{End reporting date}

\item{group_by}{Use the groupBy field to group responses by selected dimensions. If groupBy specifies age, gender, and geodimensions}

\item{granularity}{The report data organized by hour, day, week, and month.}
}
\value{
tibble with keyword report
}
\description{
Get Keyword-Level Reports
}
\examples{
\dontrun{
keyw_rep <- apl_get_keyword_report()
}
}
