% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_scene_material.R
\name{set_scene_material}
\alias{set_scene_material}
\title{Set Material for All Objects}
\usage{
set_scene_material(scene, material)
}
\arguments{
\item{scene}{A ray_scene object.}

\item{material}{A material specification created by diffuse(), metal(), dielectric(), etc.}
}
\value{
A modified ray_scene with the new material applied to all objects
}
\description{
Set Material for All Objects
}
\examples{
# Create a scene with different materials
scene = generate_cornell() \%>\%
  add_object(sphere(x=555/2, y=555/2, z=555/2, radius=100))
  
# Set all objects to be metallic
scene = set_scene_material(scene, metal(color="gold"))

# Set all objects to be glass
scene = set_scene_material(scene, dielectric())
}
