% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BtcAddresses.R
\name{PubKey2PubHash}
\alias{PubKey2PubHash}
\title{Create public key hash from 512-bit public key}
\usage{
PubKey2PubHash(pubkey, mainnet = TRUE)
}
\arguments{
\item{pubkey}{\code{character}, the public key.}

\item{mainnet}{\code{logical}, whether the WIF should correspond
to the mainnet or testnet.}
}
\value{
\code{character}, the hash of a public key
}
\description{
This function returns the associated public key hash
from a 512-bit public key by using the \code{hash160()} function.
}
\references{
\url{https://en.bitcoin.it/wiki/Address}
}
\seealso{
Other BtcAdresses: \code{\link{BTCADR-class}},
  \code{\link{PrivKey2PubKey}}, \code{\link{PrivKey2Wif}},
  \code{\link{PubHash2BtcAdr}}, \code{\link{Wif2PrivKey}},
  \code{\link{base58CheckDecode}},
  \code{\link{base58CheckEncode}}, \code{\link{concatHex}},
  \code{\link{createBtcAdr}},
  \code{\link{createPrivateKey}}, \code{\link{decodeHex}},
  \code{\link{hash160}}, \code{\link{hash256}},
  \code{\link{validBtcAdr}}
}
\author{
Bernhard Pfaff
}
\concept{BtcAdresses}
