% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lens.R
\name{lens}
\alias{lens}
\title{Access the lens database}
\usage{
lens(type = "equidistant", return = "coef")
}
\arguments{
\item{type}{Character vector of length one. Lens identifier. See \emph{Details}.}

\item{return}{Character vector of length one. Either \code{"coef"}(default) or
\code{"fov"}. Controls whether to return projection coefficients or maximum FOV.}
}
\value{
Numeric vector. Depends on \code{return}:
\describe{
\item{"coef"}{Polynomial coefficients of the projection function
(relative radius as a function of \code{theta}, radians).}
\item{"fov"}{numeric vector of length one. Maximum field of view (deg).}
}
}
\description{
Retrieve projection coefficients and field-of-view (FOV, deg) for known
lenses. Coefficients expect zenith angle in radians and return relative
radius.
}
\details{
In upward-looking leveled hemispherical photography, the zenith corresponds
to the center of a circular image whose perimeter represents the horizon,
assuming a lens with a 180° field of view. The relative radius is the radial
distance to a given point, expressed as a fraction of the maximum radius
(i.e., the horizon). The equidistant projection model, also called polar
projection, is the standard reference model, characterized by a linear
relationship between zenith angle and relative radius.

Real lenses deviate from ideal projections. Following
\href{https://www.schleppi.ch/patrick/hemisfer/}{Hemisfer software}, this package
models deviations with polynomial functions. All angular values are in
radians.

Currently available lenses:
\describe{
\item{"equidistant"}{Ideal equidistant projection
\insertCite{Schneider2009}{rcaiman}.}
\item{"Nikkor_10.5mm"}{AF DX Fisheye Nikkor 10.5mm f/2.8G ED
\insertCite{Pekin2009}{rcaiman}.}
\item{"Nikon_FCE9"}{Nikon FC-E9 converter \insertCite{Diaz2024}{rcaiman}.}
\item{"Olloclip"}{Auxiliary lens for mobile devices manufactured by Olloclip
\insertCite{Diaz2024}{rcaiman}.}
\item{"Nikkor_8mm"}{AF–S Fisheye Nikkor 8–15mm f/3.5–4.5E ED
\insertCite{Diaz2024}{rcaiman}.}
}

See \code{\link[=calibrate_lens]{calibrate_lens()}} for fitting new projection functions.
}
\examples{
lens("Nikon_FCE9")
lens("Nikon_FCE9", return = "fov")

.fp <- function(theta, lens_coef) {
  x <- lens_coef[1:5]
  x[is.na(x)] <- 0
  for (i in 1:5) assign(letters[i], x[i])
  a * theta + b * theta^2 + c * theta^3 + d * theta^4 + e * theta^5
}

theta <- seq(0, pi/2, pi/180)
plot(theta, .fp(theta, lens()), type = "l", lty = 2,
      ylab = "relative radius")
lines(theta, .fp(theta, lens("Nikon_FCE9")))

}
\references{
\insertAllCited{}
}
