% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binarize_by_region.R
\name{binarize_by_region}
\alias{binarize_by_region}
\title{Regional thresholding of greyscale images}
\usage{
binarize_by_region(r, segmentation, method)
}
\arguments{
\item{r}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster} of one layer. Typically the blue
channel of a canopy photograph.}

\item{segmentation}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster} of one layer. A labeled
segmentation map defining the regions over which to apply the thresholding
method. Ring segmentation (see \code{\link[=ring_segmentation]{ring_segmentation()}}) is often preferred
for fisheye images \insertCite{Leblanc2005}{rcaiman}.}

\item{method}{character vector of length one. Name of the thresholding method
to apply. See \emph{Details}.}
}
\value{
Logical \link[terra:SpatRaster-class]{terra::SpatRaster} (\code{TRUE} for sky, \code{FALSE} for
non-sky) of the same dimensions as \code{r}.
}
\description{
Perform thresholding of greyscale images by applying a method
regionally, using a segmentation map.
}
\details{
This function supports several thresholding methods applied within the
regions defined by \code{segmentation}:

\describe{
\item{Methods from the \code{autothresholdr} package:}{Any method supported by
\code{\link[autothresholdr:auto_thresh]{autothresholdr::auto_thresh()}} can be used by specifying its name.
For example, \code{"IsoData"} applies the classic iterative intermeans algorithm
\insertCite{isodata;textual}{rcaiman}, which is among the most recommended
for canopy photography \insertCite{Jonckheere2005}{rcaiman}.}
\item{In-package implementation of IsoData:}{Use \code{"thr_isodata"} to apply
\code{\link[=thr_isodata]{thr_isodata()}}, a native implementation of the same algorithm}
\item{Two-corner method:}{Use \code{"thr_twocorner"} to apply
\code{\link[=thr_twocorner]{thr_twocorner()}}, which implements a geometric thresholding strategy based
on identifying inflection points in the histogram, first introduced to
canopy photography by \insertCite{Macfarlane2011;textual}{rcaiman}. Since
this method tend to fail, the fallback is \code{thr_isodata}}
}
}
\note{
When methods from the \code{autothresholdr} package are used, \code{r} values
should be constrained to the range \eqn{[0, 1]}. See \code{\link[=normalize_minmax]{normalize_minmax()}}.
}
\examples{
\dontrun{
path <- system.file("external/DSCN4500.JPG", package = "rcaiman")
zenith_colrow <- c(1276, 980)
diameter <- 756*2
caim <- read_caim(path, zenith_colrow - diameter/2, diameter, diameter)
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
r <- invert_gamma_correction(caim$Blue)
r <- correct_vignetting(r, z, c(0.0638, -0.101)) \%>\% normalize_minmax()
rings <- ring_segmentation(z, 15)
bin <- binarize_by_region(r, rings, "thr_isodata")
plot(bin)
}
}
\references{
\insertAllCited{}
}
