% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_sun_angles.R
\name{optim_sun_angles}
\alias{optim_sun_angles}
\title{Optimize sun angular coordinates}
\usage{
optim_sun_angles(model, method = c("Nelder-Mead", "BFGS", "CG", "SANN"))
}
\arguments{
\item{model}{list returned by \code{\link[=fit_cie_model]{fit_cie_model()}}.}

\item{method}{character vector. One or more optimization methods supported by
\code{\link[stats:optim]{stats::optim()}}. Each is applied independently.}
}
\value{
List like \code{model}, potentially with updated \code{sun_angles} and
\code{metric}, and a new \code{method_sun} indicating the best optimization method.
If no improvement is found, \code{method_sun} is \code{NULL}.
}
\description{
Refine the solar position in a fitted CIE sky model by optimizing zenith and
azimuth to best match observed relative radiance.
}
\details{
Evaluates one or more methods from \code{\link[stats:optim]{stats::optim()}} starting at
\code{model$sun_angles}. After each optimization the model is re‑fitted and the
process repeats until the change in solar position is < 1 deg. The best
result across methods is kept.
}
\note{
The objective function penalizes solutions that move the sun position by
more than 10 deg from the initial estimate to discourage unrealistic shifts.
}
\examples{
\dontrun{
caim <- read_caim()
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)

# See fit_cie_model() for details on below file
path <- system.file("external/sky_points.csv",
                    package = "rcaiman")
sky_points <- read.csv(path)
sky_points <- sky_points[c("Y", "X")]
colnames(sky_points) <- c("row", "col")
sun_angles <- c(z = 39.5, a = 17.4)

rr <- extract_rr(caim$Blue, z, a, sky_points)

set.seed(7)
model <- fit_cie_model(rr, sun_angles, general_sky_type = "Clear")

print(model$sun_angles)
print(model$metric)

plot(model$rr$sky_points$rr, model$rr$sky_points$pred)
abline(0,1)
lm(model$rr$sky_points$pred~model$rr$sky_points$rr) \%>\% summary()

model <- optim_sun_angles(model)
print(model$sun_angles)
print(model$metric)
model$method_sun
}
}
