% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_from_user-function.R
\name{function_from_user}
\alias{function_from_user}
\title{List functions from user}
\usage{
function_from_user(func)
}
\arguments{
\item{func}{Functions, a list of functions which are defined by a user. The
list must be non-empty. All elements of the list must be named. All elements
of the list must be functions. The list must construct 1 edge or more.}
}
\value{
A list of functions. It can be an input for generating the simulated
data, or redefined by a user using \code{\link{define}} function.
}
\description{
List functions from user
}
\examples{

function_B <- function(n){ rnorm(n, mean = 90, sd = 5) }
function_A <- function(B){ ifelse(B>=95, 1, 0) }
functions <- list(A = function_A, B = function_B)
functions <- function_from_user(functions)
}
\keyword{user-specified-function-definition}
