% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate.R
\name{login}
\alias{login}
\title{Establish a connection to the HIS of interest.}
\usage{
login(
  from,
  type,
  user_name = NULL,
  password = NULL,
  driver_name = NULL,
  db_name = NULL,
  port = NULL
)
}
\arguments{
\item{from}{The URL to the HIS of interest. For APIs, this must be the base
URL (required).}

\item{type}{The source name (required). The current version of the package
covers the following RDBMS and HIS types: "ms sql", "mysql", "postgresql",
"sqlite", "dhis2", and "sormas".}

\item{user_name}{The user name (optional).}

\item{password}{The user's password (optional). When the password is not
provided (set to \code{NULL}), the user will be prompt to enter the password.}

\item{driver_name}{The driver name (optional). This is only needed for
connecting to RDBMS only.}

\item{db_name}{The database name (optional). This is only needed for
connecting to RDBMS only.}

\item{port}{The port ID (optional). This is only needed for connecting to
RDBMS only.}
}
\value{
A connection object
}
\description{
The current version of the package supports basic authentication (using the
username and password) and personal authentication key (using API key and
bearer token).
}
\examples{
# connect to the test MySQL server
\dontrun{
  login <- login(
    from = "mysql-rfam-public.ebi.ac.uk",
    type = "mysql",
    user_name = "rfamro",
    password = "",
    driver_name = "",
    db_name = "Rfam",
    port = 4497
  )
}

# connect to a DHIS2 instance
\dontrun{
  dhi2s_login <- login(
    type = "dhis2",
    from = "https://smc.moh.gm/dhis",
    user_name = "test",
    password = "Gambia@123"
  )
}

# connect to SORMAS
\dontrun{
  sormas_login <- login(
    type = "sormas",
    from = "https://demo.sormas.org/sormas-rest",
    user_name = "SurvSup",
    password = "Lk5R7JXeZSEc"
  )
}

}
