% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{print.realtest_results_summary}
\alias{print.realtest_results_summary}
\alias{summary.realtest_results}
\title{Summarise and Display Test Results}
\usage{
\method{print}{realtest_results_summary}(x, label_fail = "fail", ...)

\method{summary}{realtest_results}(object, label_pass = "pass", label_fail = "fail", ...)
}
\arguments{
\item{x}{object returned by \code{summary.realtest_results}}

\item{label_fail}{single string labelling failed test cases}

\item{...}{currently ignored}

\item{object}{list of objects of class \code{realtest_result},
see \code{\link{E}}.}

\item{label_pass}{single string denoting the default name for
unnamed prototypes}
}
\value{
\code{print.realtest_results_summary} returns \code{x}, invisibly.

\code{summary.realtest_results} returns an object of class
\code{realtest_results_summary} which is a data frame summarising
the test results, featuring the following columns:
\itemize{
\item \code{call} -- the name of the function tested,
\item \code{match} -- the name of the first matching prototype,
   \code{label_pass} if it is unnamed or \code{label_fail} if
   there is no match,
\item \code{.file} (optional) -- the name of the source file which
   defined the expectation,
\item \code{.line} (optional) -- line number,
\item \code{.expr} (optional) -- source code of the whole tested expression.
}
}
\description{
An example (write your own which will better suit your needs)
way to summarise the results returned by \code{test_dir}.
}
\examples{
# r <- test_dir("~/R/realtest/inst/realtest")  # some path
# s <- summary(r)  # summary.realtest_results
# print(s)  # print.realtest_results_summary
# stopifnot(!any(s[["match"]]=="fail"))  # halt if there are failed tests

}
\seealso{
The official online manual of \pkg{realtest} at \url{https://realtest.gagolewski.com/}

Related functions:
\code{\link{test_dir}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
