% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R, R/compound-constants.R
\docType{data}
\name{CharacterClasses}
\alias{CharacterClasses}
\alias{ALPHA}
\alias{ALNUM}
\alias{BLANK}
\alias{CNTRL}
\alias{DIGIT}
\alias{GRAPH}
\alias{LOWER}
\alias{PRINT}
\alias{PUNCT}
\alias{SPACE}
\alias{UPPER}
\alias{HEX_DIGIT}
\alias{ANY_CHAR}
\alias{GRAPHEME}
\alias{NEWLINE}
\alias{DGT}
\alias{WRD}
\alias{SPC}
\alias{NOT_DGT}
\alias{NOT_WRD}
\alias{NOT_SPC}
\alias{ASCII_DIGIT}
\alias{ASCII_LOWER}
\alias{ASCII_UPPER}
\alias{ASCII_ALPHA}
\alias{ASCII_ALNUM}
\alias{UNMATCHABLE}
\title{Class Constants}
\format{An object of class \code{regex} (inherits from \code{character}) of length 1.}
\usage{
ALPHA

ALNUM

BLANK

CNTRL

DIGIT

GRAPH

LOWER

PRINT

PUNCT

SPACE

UPPER

HEX_DIGIT

ANY_CHAR

GRAPHEME

NEWLINE

DGT

WRD

SPC

NOT_DGT

NOT_WRD

NOT_SPC

ASCII_DIGIT

ASCII_LOWER

ASCII_UPPER

ASCII_ALPHA

ASCII_ALNUM

UNMATCHABLE
}
\description{
Match a class of values. These are typically used in combination with
\code{\link{char_class}} to create new character classes.
}
\examples{
# R character classes
ALNUM
ALPHA
BLANK
CNTRL
DIGIT
GRAPH
LOWER
PRINT
PUNCT
SPACE
UPPER
HEX_DIGIT

# Special chars
ANY_CHAR
GRAPHEME
NEWLINE

# Generic classes
DGT
WRD
SPC

# Generic negated classes
NOT_DGT
NOT_WRD
NOT_SPC

# Non-locale-specific classes
ASCII_DIGIT
ASCII_LOWER
ASCII_UPPER
ASCII_ALPHA
ASCII_ALNUM

# An oxymoron
UNMATCHABLE

# Usage
x <- c("a1 A", "a1 a")
rx <- LOWER \%R\% DIGIT \%R\% SPACE \%R\% UPPER
stringi::stri_detect_regex(x, rx)
}
\seealso{
\code{\link{ClassGroups}} for the functional form,
\code{\link{SpecialCharacters}} for regex metacharacters,
\code{\link{Anchors}} for constants to match the start/end of a string,
\code{\link{WordBoundaries}} for contants to match the start/end of a word.
}
\keyword{datasets}
