% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R, R/hydrobudget-simulation.R
\name{compute_recharge}
\alias{compute_recharge}
\alias{compute_recharge.default}
\alias{compute_recharge.hydrobudget}
\title{Simulation using a recharge model}
\usage{
compute_recharge(
  obj,
  rcn,
  climate,
  rcn_climate,
  period = NULL,
  workers = 1,
  ...
)

\method{compute_recharge}{default}(
  obj,
  rcn,
  climate,
  rcn_climate,
  period = NULL,
  workers = 1,
  ...
)

\method{compute_recharge}{hydrobudget}(
  obj,
  rcn,
  climate,
  rcn_climate,
  period = NULL,
  workers = 1,
  ...
)
}
\arguments{
\item{obj}{The recharge object.}

\item{rcn}{The RCN values. Input can be a data.frame/data.table or a path to a data file.}

\item{climate}{The daily total precipitation (mm/d) and average daily temperature (°C). Input can be a data.frame/data.table or a path to a data file.}

\item{rcn_climate}{The relation between the RCN and climate cells. Input can be a data.frame/data.table or a path to a data file.}

\item{period}{The start and end years. If not provided, the start/end years will be extracted from the climate data.}

\item{workers}{The number of workers to use in the parallel computations. If NULL, an optimal number of cores will be used. This optimal number is also the maximum value. Default value is 1 (no parallelization).}

\item{...}{Other arguments passed to methods}
}
\value{
The water budget
}
\description{
Performs a simulation of water recharge using a specific model.

HydroBudget is a spatially distributed GWR model that computes a superficial water budget on
grid cells of regional-scale watersheds. Runoff, actual evapotranspiration (AET), and potential
GWR are simulated for each grid cell, with a monthly time step, and fluxes do not
transfer from a cell to another (no water routing). The model inputs are distributed daily
precipitation and temperature as well as distributed data of pedology, land cover, and slope.
}
\details{
The expected columns for the RCN data set input are:
\itemize{
\item \strong{rcn_id}, the RCN cell ID
\item \strong{RCNII}
\item \strong{lon}
\item \strong{lat}
}

The expected columns for the climate data set input are:
\itemize{
\item \strong{climate_id} the climate cell ID
\item \strong{day}
\item \strong{month}
\item \strong{year}
\item \strong{t_mean}
\item \strong{p_tot}
\item \strong{lat}
}

The expected columns for the RCN-climate data set input are:
\itemize{
\item \strong{climate_id} the climate cell ID
\item \strong{rcn_id}, the RCN cell ID
}

The columns of the water budget data set output are:
\itemize{
\item \strong{year}
\item \strong{month}
\item \strong{vi}
\item \strong{t_mean}
\item \strong{runoff}
\item \strong{pet}
\item \strong{aet}
\item \strong{gwr}
\item \strong{runoff_2}
\item \strong{delta_reservoir}
\item \strong{rcn_id}
}
}
\examples{
\dontrun{
# Use input example files provided by the package
base_url <- "https://github.com/gwrecharge/rechaRge-book/raw/main/examples/input/"
input_rcn <- paste0(base_url, "rcn.csv.gz")
input_climate <- paste0(base_url, "climate.csv.gz")
input_rcn_climate <- paste0(base_url, "rcn_climate.csv.gz")

# Calibration parameters
HB <- rechaRge::new_hydrobudget(
  T_m = 2.1, # melting temperature (°C)
  C_m = 6.2, # melting coefficient (mm/°C/d)
  TT_F = -17.6, # Threshold temperature for soil frost (°C)
  F_T = 16.4, # Freezing time (d)
  t_API = 3.9, # Antecedent precipitation index time (d)
  f_runoff = 0.63, # Runoff factor (-)
  sw_m = 431, # Maximum soil water content (mm)
  f_inf = 0.07 # infiltration factor (-)
)

# Simulation period
simul_period <- c(2010, 2017)

# Parallel computing option
# workers <- 6

# Simulation with the HydroBudget model
water_budget <- rechaRge::compute_recharge(
  HB,
  rcn = input_rcn,
  climate = input_climate,
  rcn_climate = input_rcn_climate,
  period = simul_period
  # workers = workers
)
head(water_budget)
}
}
