% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_growth_forms.R
\name{rl_growth_forms}
\alias{rl_growth_forms}
\title{Growth forms}
\usage{
rl_growth_forms(
  code = NULL,
  year_published = NULL,
  latest = NULL,
  possibly_extinct = NULL,
  possibly_extinct_in_the_wild = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{code}{Character. One or more growth form codes (e.g. "TREE", "SHRUB").
Use \code{rl_growth_forms()} with no arguments to list available growth form codes.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{possibly_extinct}{Optional. Logical. Filter for species flagged as possibly extinct.}

\item{possibly_extinct_in_the_wild}{Optional. Logical. Filter for species possibly extinct in the wild.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
If \code{code = NULL}, the tibble contains available growth form codes and their descriptions.
If \code{code} is provided, the tibble contains assessment data for the specified growth form(s), including
year, taxon details, and other relevant metadata.
}
\description{
Retrieve IUCN Red List assessments by growth form.
}
\details{
If \code{code} is \code{NULL}, this returns the available growth form codes and their descriptions.
If a \code{code} (or multiple codes) is provided, retrieves the IUCN assessments for those growth forms.
}
\examples{
\dontrun{
# List available growth form codes
rl_growth_forms()

# Get assessments for tree growth form (e.g Geophyte)
rl_growth_forms(code = "GE")

# Get assessments for multiple growth forms (e.g Hydrophyte, Lithophyte)
rl_growth_forms(code = c("H", "L"), page = c(1, 2))
}
}
