% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_red_list_categories.R
\name{rl_red_list_categories}
\alias{rl_red_list_categories}
\title{IUCN Red List Categories}
\usage{
rl_red_list_categories(
  code = NULL,
  year_published = NULL,
  latest = NULL,
  possibly_extinct = NULL,
  possibly_extinct_in_the_wild = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{code}{Character. One or more Red List category codes (e.g., "CR", "EN").
Use \code{\link[=rl_red_list_categories]{rl_red_list_categories()}} to list available categories.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{possibly_extinct}{Optional. Logical. Filter for species flagged as possibly extinct.}

\item{possibly_extinct_in_the_wild}{Optional. Logical. Filter for species possibly extinct in the wild.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
If \code{code = NULL}, the tibble contains available Red List categories with columns such as code and description.
If \code{code} is provided, the tibble contains assessment data for the specified category(ies), including year, taxon details,
and other relevant metadata.
}
\description{
Retrieve species assessments based on their Red List threat categories.
If \code{code = NULL}, it returns a list of available Red List categories.
If \code{code} is provided, it retrieves assessments for species in the specified category(ies).
}
\examples{
\dontrun{
# List all Red List categories
rl_red_list_categories()

# Get Critically Endangered species assessments
rl_red_list_categories(code = "CR")

# Get Vulnerable species assessments published in 2020
rl_red_list_categories(
  code = "VU",
  year_published = 2020
)
}
}
