% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis.testing.R
\name{test_tilted_slopes}
\alias{test_tilted_slopes}
\title{significance of regression slope (the marginal effect) under moderation
testing restriction: the sig. of beta_x under the moderation of z1, with or without additional interaction terms (z2, z3, etc.)}
\usage{
test_tilted_slopes(
  reg.coef,
  v = NULL,
  model,
  x_var.name,
  moderator.name,
  mod.n.sd = 1,
  data,
  t.value.col = 3,
  Pr.col = 4
)
}
\arguments{
\item{reg.coef}{a data.frame (or matrix) of regression result or a coeftest object, e.g. summary(lm_model)$coef, coeftest(lm_model, cluster.vcov(lm_model, cbind(data$group1,  data$group2)))}

\item{v}{a customized variance-covariance matrix}

\item{model}{the model object, such as a "lm" object}

\item{x_var.name}{main independent variable name in model, a string}

\item{moderator.name}{moderator name in model, a string}

\item{mod.n.sd}{specify the strength of the moderating effects, in the unit of s.d.s of the moderator, which can take negative values}

\item{data}{data used for regression}

\item{t.value.col}{col number of the t-score in reg.coef}

\item{Pr.col}{col number of the Prob.(>|t|)) in reg.coef}
}
\description{
significance of regression slope (the marginal effect) under moderation
testing restriction: the sig. of beta_x under the moderation of z1, with or without additional interaction terms (z2, z3, etc.)
}
\examples{
data(mtcars)
m1 <- lm(mpg ~ vs + carb + hp + wt + wt * hp , data = mtcars)
test_tilted_slopes(reg.coef = summary(m1)$coef, model = m1, 
                   x_var.name = "wt", moderator.name = "hp", data = mtcars)

}
