% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadTileAndUpload.R
\name{numCoresToUse}
\alias{numCoresToUse}
\title{Estimate Number of CPU Cores to Use for Parallel Processing}
\usage{
numCoresToUse(min = 2, max = NULL)
}
\arguments{
\item{min}{An integer specifying the minimum number of cores to use. Default is \code{2}.}

\item{max}{An integer specifying the maximum number of cores available,
typically the number of physical cores. Default is
\code{max(1L, getOption("Ncpus", 1L), parallel::detectCores() - 1, logical = FALSE, na.rm = TRUE)}.}
}
\value{
An integer representing the number of cores that can be used for
parallel tasks, ensuring at least \code{min} cores are used, while subtracting
one for the current process and an estimate of actively used threads (via
\code{detectActiveCores()}).
}
\description{
This function estimates the number of CPU cores that can be safely used for
parallel processing, taking into account a minimum threshold, the total
number of physical cores, and currently active threads.
}
\note{
This function depends on \code{detectActiveCores()} and is not supported on
Windows systems.
}
\examples{
if (FALSE) {
  numCoresToUse()
  numCoresToUse(min = 4)
}

}
\seealso{
\code{\link[=detectActiveCores]{detectActiveCores()}}
}
